import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

class FMSendFileConnection extends Thread {
  FMSendFileDialog sendFileDialog;
  Socket socket;
  FileInputStream fis;
  int fileSize;
  DataInputStream is;
  DataOutputStream os;

  public FMSendFileConnection(FMSendFileDialog sendFileDialog, Socket socket, String fileName) throws IOException {
    this.sendFileDialog = sendFileDialog;
    this.socket = socket;

    fis = new FileInputStream(fileName);
    fileSize = fis.available();
    is = new DataInputStream(fis);
    os = new DataOutputStream(socket.getOutputStream());
  };

  public void close() {
    try {
      socket.close();
      os.close();
    }
    catch(IOException e) {
    };
    stop();
  };

  public void run() {
    byte[] buffer;
    int bytesRead = 0;
    int bytesWritten;

    buffer = new byte[2048];
    bytesWritten = 0;
    while(true) {
      try {
	bytesRead = is.read(buffer);
		
	if(bytesRead == -1) {
	  sendFileDialog.button.setText("OK");
	  socket.close();
	  break;
	};
	
	os.write(buffer, 0, bytesRead);
	bytesWritten += bytesRead;

	sendFileDialog.progressBar.setValue((100 * bytesWritten) / fileSize);
	sendFileDialog.info.setText("Completed : " + ((100 * bytesWritten) / fileSize) + "%");
      }
      catch(IOException e) {
	close();
	break;
      };
    };
  };
};	
	
      


public class FMSendFileDialog extends JDialog {
  JFrame frame;
  FMUser user;
  JLabel info;
  JProgressBar progressBar;
  FMSendFileConnection sendFileConnection;
  JButton button;
  
  class AbortButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      sendFileConnection.close();
      FMSendFileDialog.this.setVisible(false);
      FMSendFileDialog.this.dispose();
    };
  };

  public void start() {
      sendFileConnection.start();
  };

  public FMSendFileDialog(JFrame frame, FMUser user, Socket socket, String fileName) throws IOException {	
    super(frame, "Sending file to  : " + user.getNickName() + " [" + user.getRealName() + "]", false);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    //JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.frame = frame;
    this.user = user;

    sendFileConnection = new FMSendFileConnection(this, socket, fileName);
   
    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    info = new JLabel("Completed :");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(info, c);
    contentPane.add(info);

    progressBar = new JProgressBar();
    progressBar.setOrientation(JProgressBar.HORIZONTAL);
    progressBar.setMinimum(0);
    progressBar.setMaximum(100);
    progressBar.setValue(50);
			  
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(progressBar, c);
    contentPane.add(progressBar);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Abort");
    button.addActionListener(new AbortButtonListener());
    panel.add(button);

    //sendFileConnection.start();
  };
};
