import java.io.*;

public class FMOffLineMessage {
  FMUser from;
  FMUser to;
  String title;
  String message;

  public FMOffLineMessage() {
    from = null;
    to = null;
    title = "No title";
    message = "No message";
  };

  public FMUser getFrom() {
    return from;
  };

  public void setFrom(FMUser from) {
    this.from = from;
  };

  public FMUser getTo() {
    return to;
  };

  public void setTo(FMUser to) {
    this.to = to;
  };

  public String getTitle() {
    return title;
  };

  public void setTitle(String title) {
    this.title = title;
  };

  public String getMessage() {
    return message;
  };

  public void setMessage(String message) {
    this.message = message;
  };

  public void read(DataInputStream is) throws IOException {
    from = new FMUser();
    from.read(is);

    to = new FMUser();
    to.read(is);
    title = is.readUTF();
    message = is.readUTF();
  };

  public void write(DataOutputStream os) throws IOException {
    from.write(os);
    to.write(os);
    os.writeUTF(title);
    os.writeUTF(message);
  };

  public String toString() {
    return "[From : " + from.getNickName() + "] [Title : " + title + "]";
  };
};
