import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;

public class FMMessageDialog extends JDialog {
  JFrame frame;
  FMClient client;
  JTextArea replyArea;
  FMUser sender;

  class OKButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMMessageDialog.this.setVisible(false);
      FMMessageDialog.this.dispose();
    };
  };

  class SendReplyButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      String message;

      message = replyArea.getText();
      if(message != null) {
	try {
	  System.out.println("Sending reply " + message + " to " + sender + sender.getHostAddress()+ sender.getHostPort());
	  client.sendMessage(sender, message);
	}
	catch(IOException e) {
	  JOptionPane.showMessageDialog(frame, "Cannot send reply");
	  return;
	};
      };
      
      FMMessageDialog.this.setVisible(false);
      FMMessageDialog.this.dispose();
    };
  };

  
  
  public FMMessageDialog(JFrame frame, FMClient client, FMUser sender, String message) {	
    super(frame, "New message", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.frame = frame;
    this.client = client;
    this.sender = sender;

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("Message from : " + sender.getNickName() + " [" + sender.getRealName() + "]");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    textArea = new JTextArea(message, 5, 40);
    textArea.setFont(new Font("fixed", Font.PLAIN, 14));
    textArea.setEditable(false);
    scrollPane = new JScrollPane(textArea);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);

    label = new JLabel("Reply :");
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    replyArea = new JTextArea(5, 40);
    replyArea.setFont(new Font("fixed", Font.PLAIN, 14));
    scrollPane = new JScrollPane(replyArea);
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(scrollPane, c);
    contentPane.add(scrollPane);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Send reply");
    button.addActionListener(new SendReplyButtonListener());
    panel.add(button);
    
    button = new JButton("OK");
    button.addActionListener(new OKButtonListener());
    panel.add(button);
  };
};
