import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class FMMainWindow extends JPanel {
  JFrame frame;
  FMClient client;
  JLabel messageArea;
  JList connectedUsersJList;
  DefaultListModel connectedUsersList;
  JList userJList;
  DefaultListModel userList;
  JList messageJList;
  DefaultListModel messageList;
  FMClientUserChecker userChecker;
  boolean loggedIn;

  class RegisterButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMRegisterDialog dialog;

      dialog = new FMRegisterDialog(frame, client);
      dialog.pack();
      dialog.show();
    };
  };

  class AboutButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMAboutDialog dialog;

      dialog = new FMAboutDialog(frame);
      dialog.pack();
      dialog.show();
    };
  };

  class QuitButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      System.exit(0);
    };
  };

  class LoginButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      String userID = "";
      String password;
      FMLoginDialog dialog;

      if(loggedIn) {
	JOptionPane.showMessageDialog(frame, "Already logged in");
	return;
      };
      
      loggedIn = false;

      dialog = new FMLoginDialog(frame, FMMainWindow.this, client);
      dialog.pack();
      dialog.show();
    };
  };

  class LogoutButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      if(!loggedIn) {
	JOptionPane.showMessageDialog(frame, "Not logged in");
	return;
      };

      try {
	if(!client.logout()) {
	  JOptionPane.showMessageDialog(frame, "Cannot logout");
	  return;
	};
      }
      catch(IOException e) {
	JOptionPane.showMessageDialog(frame, "Cannot logout");
      };

      loggedIn = false;

      connectedUsersList.removeAllElements();
      messageList.removeAllElements();

      JOptionPane.showMessageDialog(frame, "Logged out");
    };
  };

  class SettingsButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMSettingsDialog dialog;

      dialog = new FMSettingsDialog(frame, client.getSettings());
      dialog.pack();
      dialog.show();
    };
  };
   

  class AddUserButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMQueryDialog dialog;

      if(!loggedIn) {
	JOptionPane.showMessageDialog(frame, "Not logged in");
	return;
      };
      
      dialog = new FMQueryDialog(frame, FMMainWindow.this, client);
      dialog.pack();
      dialog.show();
    };
  };

  class RemoveUserButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMUser user;

      user = (FMUser)userJList.getSelectedValue();
      if(user != null) {
	if(JOptionPane.showConfirmDialog(frame, "Delete user", "Delete user?", JOptionPane.YES_NO_OPTION) == 0) {
	  userList.removeElement(user);
	};
      };
    };
  };

  class InfoButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMInfoDialog dialog;
      FMUser user;
      
      user = (FMUser)userJList.getSelectedValue();

      if(user != null) {
	dialog = new FMInfoDialog(frame, user);
	dialog.pack();
	dialog.show();
      };
    };
  };

  class InfoCButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMInfoDialog dialog;
      FMUser user;

      if(!loggedIn) {
	JOptionPane.showMessageDialog(frame, "Not logged in");
	return;
      };
      
      user = (FMUser)connectedUsersJList.getSelectedValue();

      if(user != null) {
	dialog = new FMInfoDialog(frame, user);
	dialog.pack();
	dialog.show();
      };
    };
  };

  class SendMessageButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMUser user;
      String message;

      if(!loggedIn) JOptionPane.showMessageDialog(frame, "Not logged in");

      user = (FMUser)connectedUsersJList.getSelectedValue();

      if(user != null) {
	try {
	  message = JOptionPane.showInputDialog(frame, "Message for " + user, "Send message", JOptionPane.INFORMATION_MESSAGE);
	  
	  client.sendMessage(user, message);
	}
	catch(IOException exception) {
	  JOptionPane.showMessageDialog(frame, "Cannot send message");
	};
      };
    };
  };

  class TalkButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMUser user;
      String message;

      if(!loggedIn) {
	JOptionPane.showMessageDialog(frame, "Not logged in");      
	return;
      };

      user = (FMUser)connectedUsersJList.getSelectedValue();

      if(user != null) {
	try {
	  client.talk(user);
	}
	catch(IOException exception) {
	  JOptionPane.showMessageDialog(frame, "Cannot talk to user");
	};
      };
    };
  };

  class SendFileButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      String fileName;
      String fileDir;
      FileDialog fileDialog;
      FMUser user;

      if(!loggedIn) {
	JOptionPane.showMessageDialog(frame, "Not logged in");
	return;
      };
      
      /* Swing throws a null pointer exception in its classes and I don't know
	 why. That prevents the correct usage of the file dialog. After
	 the OPEN button is pressed swing throws an exception which stops the 
	 execution. It isn't possible to get the selected file.
	 I use, as an alternative, the "manual file choosing", that is,
	 prompting the user for the directory and the filename.
	 That exception is thrown everywhere when I close a dialog. 
	 But in the other functions the dialog closing is always the last
	 instruction, then, even if the function aborts, there are no problems.
      */

      /*fileDialog = new FileDialog(frame);
      fileDialog.setMode(FileDialog.LOAD);
      fileDialog.show();

      --> Here swing throws a nullpointer exception. The function aborts. Don't know why <--

      fileName = fileDialog.getFile();
      if(fileName == null) return;

      fileDir = fileDialog.getDirectory();

      System.out.println("Selected : " + fileName);*/

      user = (FMUser)connectedUsersJList.getSelectedValue();
      
      fileDir = JOptionPane.showInputDialog(frame, "Directory (slash terminated)", "Send file", JOptionPane.INFORMATION_MESSAGE);
      fileName = JOptionPane.showInputDialog(frame, "File name", "Send file", JOptionPane.INFORMATION_MESSAGE);
      
      if(user != null) {
	try {
	  client.sendFile(user, fileDir, fileName);
	}
	catch(IOException exception) {
	  JOptionPane.showMessageDialog(frame, "Cannot send file to user");
	};
      };
    };
  };

  class SaveButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      DataOutputStream os;
      Enumeration e;
      FMUser currentUser;

      try {
	os = new DataOutputStream(new FileOutputStream("Config/jFM.userlist"));
	e = userList.elements();
	while(e.hasMoreElements()) {
	  currentUser = (FMUser)e.nextElement();
	  currentUser.setPassword("*");
	  currentUser.write(os);
	};
	os.close();

	JOptionPane.showMessageDialog(frame, "User list saved");
      }
      catch(IOException exception) {
	JOptionPane.showMessageDialog(frame, "Error saving user list");
      };
    };
  };

  class SendOffLineMessageButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMUser user;
      FMOffLineMessageDialog dialog;

      if(!loggedIn) JOptionPane.showMessageDialog(frame, "Not logged in");

      user = (FMUser)userJList.getSelectedValue();

      if(user != null) {
	dialog = new FMOffLineMessageDialog(frame, client, user);
	dialog.pack();
	dialog.show();
      };
    };
  };
	
  public void loadUserList() {
    DataInputStream is;

    try {
      is = new DataInputStream(new FileInputStream("Config/jFM.userlist"));

      while(true) {
	FMUser currentUser;

	currentUser = new FMUser();
	currentUser.read(is);
	userList.addElement(currentUser);
      };
    }
    catch(IOException e) {
    };
  };
	
  class GetMessagesButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      System.out.println("Getting messages...");

      if(!loggedIn) {
	JOptionPane.showMessageDialog(frame, "Not logged in");
	return;
      };
      
      try {
	Vector messages;
	Enumeration e;

	messages = client.getMessages();
	e = messages.elements();
	while(e.hasMoreElements()) {
	  FMOffLineMessage message;

	  message = (FMOffLineMessage)e.nextElement();
	  messageList.addElement(message);
	};

	JOptionPane.showMessageDialog(frame, "Messages received");
      }
      catch(IOException exception) {
	JOptionPane.showMessageDialog(frame, "Error receiving messages");
      };
    };
  };

  class ReadMessageButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMOffLineMessage message;

      message = (FMOffLineMessage)messageJList.getSelectedValue();
      
      if(message != null) {
	FMMessageViewDialog dialog;

	dialog = new FMMessageViewDialog(frame, message);
	dialog.pack();
	dialog.show();
      };
    };
  };

  class ReplyMessageButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMOffLineMessage message;

      if(!loggedIn) {
	JOptionPane.showMessageDialog(frame, "Not logged in");
	return;
      };
      
      message = (FMOffLineMessage)messageJList.getSelectedValue();
      
      if(message != null) {
	FMOffLineMessageDialog dialog;

	dialog = new FMOffLineMessageDialog(frame, client, message.getFrom());
	dialog.pack();
	dialog.show();
      };
    };
  };

  class DeleteMessageButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMOffLineMessage message;

      message = (FMOffLineMessage)messageJList.getSelectedValue();
      if(message != null) {
	if(JOptionPane.showConfirmDialog(frame, "Delete message", "Delete message?", JOptionPane.YES_NO_OPTION) == 0) {
	  messageList.removeElement(message);
	};
      };
    };
  };

  class SaveMessageButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMOffLineMessage message;
      String fileName;
      
      message = (FMOffLineMessage)messageJList.getSelectedValue();
      if(message != null) {
	fileName = JOptionPane.showInputDialog(frame, "Filename :", "Save message", JOptionPane.INFORMATION_MESSAGE);
	try {
	  DataOutputStream fos;

	  fos = new DataOutputStream(new FileOutputStream(fileName));
	  fos.writeBytes("From : " + message.getFrom() + "\n");
	  fos.writeBytes("To : " + message.getTo() + "\n");
	  fos.writeBytes("Title : " + message.getTitle() + "\n\n");
	  fos.writeBytes(message.getMessage());
	  fos.close();

	  JOptionPane.showMessageDialog(frame, "Messages saved");
	}
	catch(IOException exception) {
	  JOptionPane.showMessageDialog(frame, "Error saving message");
	};
      };
    };
  };
  
  public FMMainWindow(JFrame frame, FMClient client) {
    super(true);

    this.frame = frame;
    this.client = client;
    
    setLayout(new BorderLayout());

    add("North", createMenuBar());
    add("Center", createWorkWindow());
    add("South", createStatusBar());

    userChecker = new FMClientUserChecker(this, client);
    userChecker.start();
  };

  private JMenuBar createMenuBar() {
    JMenuBar menuBar;
    JMenuItem item;
    JMenu menu;
    
    menuBar = new JMenuBar();

    menu = new JMenu("Find Me");
    item = new JMenuItem("Login...");
    item.addActionListener(new LoginButtonListener());
    menu.add(item);

    item = new JMenuItem("Logout");
    item.addActionListener(new LogoutButtonListener());
    menu.add(item);

    item = new JMenuItem("Register...");
    item.addActionListener(new RegisterButtonListener());
    menu.add(item);

    item = new JMenuItem("Settings...");
    item.addActionListener(new SettingsButtonListener());
    menu.add(item);

    item = new JMenuItem("Quit");
    item.addActionListener(new QuitButtonListener());
    menu.add(item);
    
    menuBar.add(menu);

    menu = new JMenu("Online");
    item = new JMenuItem("Get user info...");
    item.addActionListener(new InfoCButtonListener());
    menu.add(item);

    item = new JMenuItem("Send message...");
    item.addActionListener(new SendMessageButtonListener());
    menu.add(item);

    item = new JMenuItem("Talk...");
    item.addActionListener(new TalkButtonListener());
    menu.add(item);

    item = new JMenuItem("Send file...");
    item.addActionListener(new SendFileButtonListener());
    menu.add(item);

    menuBar.add(menu);

    menu = new JMenu("OffLine");
    item = new JMenuItem("Get user info...");
    item.addActionListener(new InfoButtonListener());
    menu.add(item);

    item = new JMenuItem("Send message...");
    item.addActionListener(new SendOffLineMessageButtonListener());
    menu.add(item);

    menuBar.add(menu);

    menu = new JMenu("Userlist");
    item = new JMenuItem("Add user...");
    item.addActionListener(new AddUserButtonListener());
    menu.add(item);

    item = new JMenuItem("Remove user...");
    item.addActionListener(new RemoveUserButtonListener());
    menu.add(item);

    item = new JMenuItem("Save list");
    item.addActionListener(new SaveButtonListener());
    menu.add(item);

    menuBar.add(menu);

    menu = new JMenu("Message");
    item = new JMenuItem("Check");
    item.addActionListener(new GetMessagesButtonListener());
    menu.add(item);

    item = new JMenuItem("Read...");
    item.addActionListener(new ReadMessageButtonListener());
    menu.add(item);

    item = new JMenuItem("Reply...");
    item.addActionListener(new ReplyMessageButtonListener());
    menu.add(item);

    item = new JMenuItem("Delete...");
    item.addActionListener(new DeleteMessageButtonListener());
    menu.add(item);

    item = new JMenuItem("Save...");
    item.addActionListener(new SaveMessageButtonListener());
    menu.add(item);

    menuBar.add(menu);
    
    menu = new JMenu("Help");
    item = new JMenuItem("About");
    item.addActionListener(new AboutButtonListener());
    menu.add(item);
    menuBar.add(menu);
    
     return menuBar;
  };

  private JPanel createStatusBar() {
    JPanel statusBar;
		
    statusBar = new JPanel();
    statusBar.setLayout(new BorderLayout());
    
    messageArea = new JLabel("Java Find Me running...");
    statusBar.add("Center", messageArea);
    
    return statusBar;
  };

  private JPanel createWorkWindow() {
    JPanel workWindow;
    
    workWindow = new JPanel(true);
    workWindow.setLayout(new BorderLayout());
    
    workWindow.add("North", createToolBar());
    workWindow.add("Center", createCommandWindow());
    
    return workWindow;
  };

  private JToolBar createToolBar() {
    JToolBar toolBar;
    JButton button;
    FlowLayout layout;
    
    toolBar = new JToolBar();
    
    button = new JButton(new ImageIcon("Images/login.gif"));
    button.setToolTipText("Login");
    button.addActionListener(new LoginButtonListener());
    toolBar.add(button);
    
    button = new JButton(new ImageIcon("Images/logout.gif"));
    button.setToolTipText("Logout");
    button.addActionListener(new LogoutButtonListener());
    toolBar.add(button);
    
    return toolBar;
  };

  private JTabbedPane createCommandWindow() {
    JTabbedPane commandWindow;
    JPanel panel;
    JToolBar toolBar;
    JButton button;
    JScrollPane scrollPane;
    
    commandWindow = new JTabbedPane();

    panel = new JPanel(true);
    panel.setLayout(new BorderLayout());
    toolBar = new JToolBar();

    button = new JButton(new ImageIcon("Images/info.gif"));
    button.setToolTipText("Get user info");
    button.addActionListener(new InfoCButtonListener());
    toolBar.add(button);
    toolBar.addSeparator();
    
    button = new JButton(new ImageIcon("Images/sendMessage.gif"));
    button.setToolTipText("Send a message to user");
    button.addActionListener(new SendMessageButtonListener());
    toolBar.add(button);
    
    button = new JButton(new ImageIcon("Images/talk.gif"));
    button.setToolTipText("Talk to user");
    button.addActionListener(new TalkButtonListener());
    toolBar.add(button);
    
    button = new JButton(new ImageIcon("Images/sendFile.gif"));
    button.setToolTipText("Send a file to user");
    button.addActionListener(new SendFileButtonListener());
    toolBar.add(button);

    panel.add("North", toolBar);

    connectedUsersList = new DefaultListModel();
    connectedUsersJList = new JList(connectedUsersList);
    scrollPane = new JScrollPane(connectedUsersJList);
    panel.add("Center", scrollPane);
        
    commandWindow.addTab("Connected users", null, panel, "Show connected users");

    panel = new JPanel(true);
    panel.setLayout(new BorderLayout());
    toolBar = new JToolBar();

    button = new JButton(new ImageIcon("Images/info.gif"));
    button.setToolTipText("Get user info");
    button.addActionListener(new InfoButtonListener());
    toolBar.add(button);
    toolBar.addSeparator();

    button = new JButton(new ImageIcon("Images/sendMessage.gif"));
    button.setToolTipText("Send an off-line message to user");
    button.addActionListener(new SendOffLineMessageButtonListener());
    toolBar.add(button);
    toolBar.addSeparator();
  
    
    button = new JButton(new ImageIcon("Images/add.gif"));
    button.setToolTipText("Add a new user to user list");
    button.addActionListener(new AddUserButtonListener());
    toolBar.add(button);

    button = new JButton(new ImageIcon("Images/remove.gif"));
    button.setToolTipText("Remove a user from user list");
    button.addActionListener(new RemoveUserButtonListener());
    toolBar.add(button);
    toolBar.addSeparator();

    button = new JButton(new ImageIcon("Images/save.gif"));
    button.setToolTipText("Save the user list");
    button.addActionListener(new SaveButtonListener());
    toolBar.add(button);

    panel.add("North", toolBar);

    userList = new DefaultListModel();
    userJList = new JList(userList);
    scrollPane = new JScrollPane(userJList);
    panel.add("Center", scrollPane);

    commandWindow.addTab("User list", null, panel, "Show user list");

    panel = new JPanel(true);
    panel.setLayout(new BorderLayout());
    toolBar = new JToolBar();

    button = new JButton(new ImageIcon("Images/check.gif"));
    button.setToolTipText("Check for new messages");
    button.addActionListener(new GetMessagesButtonListener());
    toolBar.add(button);
    toolBar.addSeparator();
    
    button = new JButton(new ImageIcon("Images/read.gif"));
    button.setToolTipText("Read the message");
    button.addActionListener(new ReadMessageButtonListener());
    toolBar.add(button);
    
    button = new JButton(new ImageIcon("Images/reply.gif"));
    button.setToolTipText("Reply to the message");
    button.addActionListener(new ReplyMessageButtonListener());
    toolBar.add(button);
    toolBar.addSeparator();

    button = new JButton(new ImageIcon("Images/save.gif"));
    button.setToolTipText("Save the message");
    button.addActionListener(new SaveMessageButtonListener());
    toolBar.add(button);
    
    button = new JButton(new ImageIcon("Images/delete.gif"));
    button.setToolTipText("Delete the message");
    button.addActionListener(new DeleteMessageButtonListener());
    toolBar.add(button);

    panel.add("North", toolBar);

    messageList = new DefaultListModel();
    messageJList = new JList(messageList);
    scrollPane = new JScrollPane(messageJList);
    panel.add("Center", scrollPane);

    commandWindow.addTab("Messages", null, panel, "Off-line messages");
    
    return commandWindow;
  };

  public void addToUserList(FMUser user) {
    Enumeration e;

    e = userList.elements();
    while(e.hasMoreElements()) {
      FMUser currentUser;

      currentUser = (FMUser)e.nextElement();
      if(currentUser.getID() == user.getID()) return;
    };

    userList.addElement(user);
  };
};  
