import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.util.*;
import java.io.*;

public class FMLoginDialog extends JDialog {
  JFrame frame;
  JTextField userIDField;
  JPasswordField passwordField;
  FMClient client;
  FMMainWindow mainWindow;

  class OKButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
    
      try {
	if(!client.login(Integer.parseInt(userIDField.getText()), passwordField.getText())) {
	    JOptionPane.showMessageDialog(frame, "Cannot login");
	    return;
	};
      }
      catch(NumberFormatException e) {
	JOptionPane.showMessageDialog(frame, "Invalid user ID");
	return;
      }
      catch(IOException e) {
	JOptionPane.showMessageDialog(frame, "Cannot login");
	return;
      };

      mainWindow.loggedIn = true;
            
      FMLoginDialog.this.setVisible(false);
      FMLoginDialog.this.dispose();
      
    };
  };

  class CancelButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent event) {
      FMLoginDialog.this.setVisible(false);
      FMLoginDialog.this.dispose();
    };
  };

  public FMLoginDialog(JFrame frame, FMMainWindow mainWindow, FMClient client) {	
    super(frame, "Login", true);
    
    Container contentPane;
    GridBagLayout gridBag;
    GridBagConstraints c;
    JLabel label;
    JButton button;
    JPanel panel;
    JScrollPane scrollPane;
    JTextArea textArea;

    this.client = client;
    this.mainWindow = mainWindow;

    contentPane = getContentPane();
    
    gridBag = new GridBagLayout();
    c = new GridBagConstraints();
    
    contentPane.setLayout(gridBag);
		
    c.fill = GridBagConstraints.BOTH;
    c.weightx = 1; c.weighty = 0;
    c.gridwidth = GridBagConstraints.REMAINDER;
    c.gridheight = 1;
    
    label = new JLabel("User ID : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    userIDField = new JTextField(40);
    userIDField.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(userIDField, c);
    contentPane.add(userIDField);

    label = new JLabel("Password : ");
    c.gridwidth = GridBagConstraints.RELATIVE;
    gridBag.setConstraints(label, c);
    contentPane.add(label);

    passwordField = new JPasswordField(40);
    passwordField.setFont(new Font("fixed", Font.PLAIN, 14));
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(passwordField, c);
    contentPane.add(passwordField);

    panel = new JPanel();
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridBag.setConstraints(panel, c);
    contentPane.add(panel);
    
    button = new JButton("Login");
    button.addActionListener(new OKButtonListener());
    panel.add(button);
    
    button = new JButton("Cancel");
    button.addActionListener(new CancelButtonListener());
    panel.add(button);
  };
};
