import java.io.*;
import java.net.*;
import java.util.*;

/**
 * This class implements a thread which connects to the server
 * and check which user in the userlist is online
 */
public class FMClientUserChecker extends Thread {
  FMMainWindow mainWindow;
  FMClient client;
  int timeout;

  public FMClientUserChecker(FMMainWindow mainWindow, FMClient client) {
    this(mainWindow, client, 30);
  };

  public FMClientUserChecker(FMMainWindow mainWindow, FMClient client, int timeout) {
    this.mainWindow = mainWindow;
    this.client = client;
    this.timeout = timeout * 1000;
  };

  public void run() {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    
    while(true) {
      try {
	Enumeration e;
	FMUser user;
	int reply;

	socket = client.openConnection();
	is = new DataInputStream(socket.getInputStream());
	os = new DataOutputStream(socket.getOutputStream());

	mainWindow.connectedUsersList.removeAllElements();

	e = mainWindow.userList.elements();
	while(e.hasMoreElements()) {
	  user = (FMUser)e.nextElement();

	  os.writeInt(FMServerConnection.ONLINE);
	  os.writeInt(user.getID());

	  reply = is.readInt();
	  if(reply == FMServerConnection.SUCCESS) {
	    FMUser connectedUser;

	    connectedUser = new FMUser();
	    connectedUser.readAll(is);
	    mainWindow.connectedUsersList.addElement(connectedUser);
	  };
	};

	socket.close();
      }
      catch(IOException exception) {
      };

      try {
	sleep(timeout);
      }
      catch(InterruptedException e) {
      };
    };
  };
};
