import java.io.*;
import java.net.*;
import java.util.*;
import com.sun.java.swing.*;

public class FMClient extends Thread {
  public static final int MESSAGE = 0x00;
  public static final int TALK = 0x01;
  public static final int FILE = 0x02;

  ServerSocket mainSocket;
  FMSettings settings;
  JFrame frame;
  FMUser user;
  
  public FMClient(FMSettings settings, JFrame frame) throws IOException {
    this.settings = settings;
    this.frame = frame;
    
    mainSocket = new ServerSocket(settings.clientPort);

  };

  public FMSettings getSettings() {
    return settings;
  };

  public Socket openConnection() throws IOException {
    return new Socket(settings.getServerName(), settings.getServerPort());
  };

  public boolean register(FMUser user) throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    int reply;
    
    socket = openConnection();
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    os.writeInt(FMServerConnection.REGISTER);
    user.write(os);

    reply = is.readInt();
    if(reply == FMServerConnection.SUCCESS) {
      user.setID(is.readInt());
      socket.close();
      return true;
    };

    socket.close();
    return false;
  };

  public boolean login(int userID, String password) throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    int reply;
    
    socket = openConnection();
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    os.writeInt(FMServerConnection.LOGIN);
    os.writeInt(userID);
    os.writeUTF(password);
    os.writeInt(settings.getClientPort());

    reply = is.readInt();

    if(reply == FMServerConnection.SUCCESS) {
      user = new FMUser();
      user.read(is);
      socket.close();

      try {
	user.setHostAddress(InetAddress.getLocalHost());
	user.setHostPort(settings.getClientPort());
      }
      catch(UnknownHostException e) {
      };
	

      System.out.println("LOGIN : " + user);
      
      return true;
    };

    socket.close();
    
    return false;
  };

  public boolean logout() throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    int reply;
    
    socket = openConnection();
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    os.writeInt(FMServerConnection.LOGOUT);
    os.writeInt(user.getID());
    os.writeUTF(user.getPassword());

    reply = is.readInt();

    socket.close();

    if(reply == FMServerConnection.SUCCESS) return true;

    return false;
  };

  public Vector query(int queryType, String queryData) throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    int reply;
    int matchingsNumber;
    Vector matchings;
    int i;
    
    socket = openConnection();
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    os.writeInt(FMServerConnection.QUERY);
    os.writeInt(queryType);
    os.writeUTF(queryData);

    reply = is.readInt();
    matchingsNumber = is.readInt();
    matchings = new Vector(10, 5);
    for(i = 0; i < matchingsNumber; i++) {
      FMUser user;

      user = new FMUser();
      user.read(is);
      matchings.addElement(user);
    };

    return matchings;
  };

  public Vector getMessages() throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    int reply;
    int messagesNumber;
    Vector messages;
    int i;

    socket = openConnection();
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    os.writeInt(FMServerConnection.GETMESSAGES);
    os.writeInt(user.getID());
    os.writeUTF(user.getPassword());

    messages = new Vector(10, 5);
    
    reply = is.readInt();
    if(reply == FMServerConnection.FAILURE) {
      return messages;
    };
    
    messagesNumber = is.readInt();
    
    for(i = 0; i < messagesNumber; i++) {
      FMOffLineMessage message;

      message = new FMOffLineMessage();
      message.read(is);
      messages.addElement(message);

      System.out.println("RECEIVED : " + message.getTitle());
    };

    return messages;
  };

    
    

  public void sendMessage(FMUser user, String message) throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;

    socket = new Socket(user.getHostAddress(), user.getHostPort());
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());
    
    os.writeInt(MESSAGE);
    this.user.writeAll(os);
    os.writeUTF(message);

    socket.close();
  };

  public void talk(FMUser user) throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    FMUser remoteUser;
    FMTalkDialog talkDialog;
    Thread talkThread;
    
    socket = new Socket(user.getHostAddress(), user.getHostPort());
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    remoteUser = new FMUser();
    os.writeInt(TALK);
    
    this.user.writeAll(os);
    remoteUser.readAll(is);
    
    talkDialog = new FMTalkDialog(frame, remoteUser, socket);
    talkDialog.pack();
    talkDialog.show();
  };

  public void sendFile(FMUser user, String fileDir, String fileName) throws IOException {
    DataInputStream fis;
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    FMUser remoteUser;

    fis = new DataInputStream(new FileInputStream(fileDir + fileName));

    socket = new Socket(user.getHostAddress(), user.getHostPort());
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    remoteUser = new FMUser();
    os.writeInt(FILE);
    
    this.user.writeAll(os);
    os.writeUTF(fileName);
    remoteUser.readAll(is);

    System.out.println("Sending file to : " + remoteUser);

    try {
      FMSendFileDialog sendDialog = new FMSendFileDialog(frame, remoteUser, socket, fileDir + fileName);
      sendDialog.pack();
      sendDialog.show();
      sendDialog.start();
    }
    catch(IOException e) {
      System.out.println("Error sending file");
      socket.close();
    };
  };

  public boolean sendOffLineMessage(FMUser to, String title, String message) throws IOException {
    Socket socket;
    DataInputStream is;
    DataOutputStream os;
    FMOffLineMessage offLineMessage;
    int reply;
    
    socket = openConnection();
    is = new DataInputStream(socket.getInputStream());
    os = new DataOutputStream(socket.getOutputStream());

    offLineMessage = new FMOffLineMessage();
    offLineMessage.setFrom(user);
    offLineMessage.setTo(to);
    offLineMessage.setTitle(title);
    offLineMessage.setMessage(message);
    
    os.writeInt(FMServerConnection.MESSAGE);
    offLineMessage.write(os);
    reply = is.readInt();

    if(reply == FMServerConnection.SUCCESS) return true;

    return false;
  };

    
    

  public void run() {
    Socket connectionSocket;
    DataInputStream is;
    DataOutputStream os;


    while(true) {
      int request;
      
      try {
	connectionSocket = mainSocket.accept();

	is = new DataInputStream(connectionSocket.getInputStream());
	os = new DataOutputStream(connectionSocket.getOutputStream());

	request = is.readInt();

	switch(request) {
	case MESSAGE: {
	  String message;
	  FMUser remoteUser;
	  
	  remoteUser = new FMUser();
	  remoteUser.readAll(is);
	  message = is.readUTF();

	  connectionSocket.close();
	  
	  FMMessageDialog messageDialog = new FMMessageDialog(frame, this, remoteUser, message);
	  messageDialog.pack();
	  messageDialog.show();
	};
	break;
	case TALK: {
	  FMUser remoteUser;
	  
	  remoteUser = new FMUser();
	  remoteUser.readAll(is);
	  this.user.writeAll(os);
	  
	  FMTalkDialog talkDialog = new FMTalkDialog(frame, remoteUser, connectionSocket);
	  talkDialog.pack();
	  talkDialog.show();
	}
	break;
	case FILE: {
	  FMUser remoteUser;
	  String fileName;

	  System.out.println("Received a FILE request");

	  remoteUser = new FMUser();
	  remoteUser.readAll(is);
	  fileName = is.readUTF();
	  this.user.writeAll(os);
 

	  System.out.println("Receiving file : " + fileName);

	  try {
	    FMGetFileDialog getFileDialog = new FMGetFileDialog(frame, remoteUser, connectionSocket, "Files/" + fileName);
	    getFileDialog.pack();
	    getFileDialog.show();
	    getFileDialog.start();
	  }
	  catch(IOException e) {
	    System.out.println("Error getting file");
	    connectionSocket.close();
	  };

	};
	break;
	}
      }
      catch(IOException exception) {
	System.out.println("Error getting data");
      };

	
    };
  };
    
};
    
    
    
