import javax.swing.JTree.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.*;
import java.io.*;
import java.util.Vector;

/** Object qui permet de construire un JTree avec toute
 *  l'arborscence d'un repertoire passe en parametre
 *  au constructeur */
class MakeTree extends DefaultMutableTreeNode {
	     
  private DefaultMutableTreeNode top;
  private String nomVolume;
  private String proprietaire;
  private long taille = 0;
  private String type;
  private boolean disponible;
  private int nbFichiers = 0;
    /** Constructeur sans parametre qui appelle. Utilise au
	lancement du programme. Pratique pour ne pas avoir a charger
	un arbre entier au demarrage : gain de temps */
    public MakeTree() {
	top = new DefaultMutableTreeNode("Vide");
    }
    
    /** Seul et unique constructeur */
    public  MakeTree(File fichier){
	top = new DefaultMutableTreeNode(fichier.getName().toString());
	nomVolume = "---";
	proprietaire = "---";
	type = "CD-ROM";
	disponible = true;	  
	try{
	  File[] listDir = fichier.listFiles();
          String[] listeFichiers = fichier.list();
          
          for ( int i = 0 ; i < listeFichiers.length; i++) {
            File fichierTemp = listDir[i];
            
            if (fichierTemp.isDirectory()) {
              MakeTree DivingTree = new MakeTree(fichierTemp);
              taille = taille + DivingTree.getTaille();
              nbFichiers = nbFichiers + DivingTree.getNbFichiers();
              top.add(DivingTree.getTree());
              nbFichiers++;
            }
            else {
		    DefaultMutableTreeNode Feuille = new DefaultMutableTreeNode(fichierTemp.getName().toString());
		    taille = taille + fichierTemp.length();
		    top.add(Feuille);
		    nbFichiers++;
		}
	    }
	}catch (IndexOutOfBoundsException e){}
    }
    
    /** Renvoie le sommet d'un arbre, avec toutes ses branches */
    public DefaultMutableTreeNode getTree(){
	return top;
    }
    
    /** Renvoie le nom du sommet */
    public String getName() {
	return top.toString();
    }    

    public String toString() {
	return getName();
    }
    
    public String getNomVolume() {
	return nomVolume;
    }
    public String getProprietaire() {
	return proprietaire;
    }
    public void setNomVolume(String nomVolume) {
	this.nomVolume = nomVolume;
    }
    public void setProprietaire(String proprietaire) {
	this.proprietaire = proprietaire;
    }

    public long getTaille() {
        return taille;
    }
    public String getType() {  // a ne pas utiliser pour l'instant
	return type;           // prendre type CD
  }
  public boolean getDispo() {
    return disponible;
  }
  public void setDispo(boolean dispo) {
    disponible = dispo;
  }
  public int getNbFichiers() {
    return nbFichiers;
  }

  /** Renvoie les elements de l'arbre qui se trouvent au premier
   * niveau de la hierarchie */
  public Vector getPremierNiveau() {
    Vector resultat = new Vector();
    int cpt = 0;
    int compteFils = 0;
    int nbFils = top.getChildCount();
    while (compteFils < nbFils) {
	DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)top.getChildAt(compteFils);
        resultat.addElement((String)tmp.getUserObject());
	compteFils++;
    }      
    return resultat;
  }
    
    /** Renvoie le type du CD : CD-Audio ou CD-ROM. La seule astuce pour verifier cela 
     *  est, a noter connaissance, de voir s'il n'y a pas de repertoire, et si les 
     *  fichiers ont tous l'extension '.cda' */
  public String typeCD() {
      String nomFichier = null;
      int l; // longueur du nom de fichier;
      int cpt = 0;
      int compteFils = 0;
      int nbFils = top.getChildCount();
      while (compteFils < nbFils) {
	  if (!top.getChildAt(compteFils).isLeaf())   // On est sur un repertoire
	      return "CD-ROM";  // on n'est sur,ce n'est pas un CD audio
	  else {
	      DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)top.getChildAt(compteFils);
	      nomFichier = (String)tmp.getUserObject();
	      // Maintenant, on teste l'extension du fichier */
	      l = nomFichier.length();
	      if (!nomFichier.substring(l-4, l).equals(".cda"))
		  return "CD-ROM";  // tant pis, c'est un CD-ROM... La musique aurait pu etre bonne...
	      compteFils++;
	  }
      }
      return "CD-Audio";  // Ah... enfin un bon CD !
  }
    
}






