import java.io.*;
import java.util.Vector;

/** Class qui genere des fichiers PS */

public class GenerePS {
  String nomFichier, nomVolume, nomProprietaire, nomVolumeLong;
  Vector premierNiveau;
 
  /** Seul constructeur : prend en parametres le nom du fichier dans
   * dfljsdklgvjdfslkvjsdfklvjsdflkvbjhsdflkvbjhsdfklsgdfe nom du
   *  volume a imprimer */
  public GenerePS(String nomFichier, MakeTree arbre) {
    if (nomFichier == null)
      this.nomFichier = "pochette.ps";
    else if (nomFichier.length() > 23)
      this.nomFichier = nomFichier.substring(0, 23) + "...";
    else
      this.nomFichier = nomFichier;

    if ((nomVolume = arbre.getNomVolume()) == null)
      this.nomVolume = "--> CD <--";
    
    if (nomVolume.length() > 40)
      nomVolumeLong = nomVolume.substring(0, 40) + "...";
    else 
      nomVolumeLong = nomVolume;

    if (nomVolume.length() > 23)
      nomVolume = nomVolume.substring(0, 23) + "...";
    
    if ((nomProprietaire = arbre.getProprietaire()) == null)
      nomProprietaire = "";
    else if (nomProprietaire.length() > 23)
      nomProprietaire = nomProprietaire.substring(0, 23) + "...";
    
    // On recupere les fichiers du premier niveau de l'arbre
    premierNiveau = arbre.getPremierNiveau();
    
  }


  public void ecrisPS() {
    FileWriter fw;
    PrintWriter pw = null;
    
    // Attention aux exceptions d'entrees-sorties
        try {
          fw = new FileWriter(nomFichier);
          pw = new PrintWriter(fw);
          // Ecriture de l'entete du fichier
          pw.println("%! Pochette de CD - Generee par jCD - (c) Fabrice Clari / Cedrik Poirey");
          pw.println();
          // Et c'est parti pour du code Postscript !
          pw.println("/inch {72 mul} def        %%definition d'un pouce");
          pw.println("/cm {inch 2.54 div} def   %% definition d'un centimetre");

          pw.println();
          
          pw.println("/surface {                %% Face arriere du CD");
          pw.println("1 cm 1.6 cm moveto");
          pw.println("1 cm 15.5 cm lineto");
          pw.println("12.8 cm 15.5 cm lineto");
          pw.println("12.8 cm 1.6 cm lineto");
          pw.println("closepath");
          pw.println("} def");
          
          pw.println();
          
          pw.println("/trancheDroite {          %% Tranche droite");
          pw.println("1 cm 1 cm moveto");
          pw.println("1 cm 1.6 cm lineto");
          pw.println("12.8 cm 1.6 cm lineto");
          pw.println("12.8 cm 1 cm lineto");
          pw.println("closepath");
          pw.println("} def");
          
          pw.println();
          
          pw.println("/trancheGauche {          %% Tranche gauche");
          pw.println("1 cm 15.5 cm moveto");
          pw.println("1 cm 16.1 cm lineto");
          pw.println("12.8 cm 16.1 cm lineto");
          pw.println("12.8 cm 15.5 cm lineto");
          pw.println("closepath");
          pw.println("} def");
          
          pw.println();
          
          pw.println("surface stroke            %% Affichage des contours");
          pw.println("trancheDroite stroke");
          pw.println("trancheGauche stroke");

          pw.println();

          pw.println("/Times-Roman findfont 15 scalefont setfont");
          pw.println("%% Ecriture dans les tranches");
          pw.println("1.2 cm 1.13 cm moveto     %% Placement dans la tranche gauche");
          pw.println("(" + nomVolumeLong + ") show");
          pw.println("1.2 cm 15.6 cm moveto     %% Placement dans la tranche droite");
          pw.println("%% on ecrit horizontalement dans la tranche droite");
          pw.println("(" + nomVolumeLong + ") show");
          
          pw.println();
          
          // Maintenant, on affiche le contenu du CD. Seulement le premier niveau
          // On definit quelques variables et quelques fonctions, et on remercie
          // au passage Adobe pour son langage Postscript... Il n'y a meme pas de
          // fonction pour passer a la ligne quand on ecrit du texte...
          
          pw.println("/saut {0.4 cm} def        %% Espace que l'on saute entre les lignes");
          pw.println();
          pw.println("/newline {                %% Fonction pour aller a la ligne");
          pw.println("show");    
          pw.println("/y0 y0 saut sub store");
          pw.println("x0 y0 moveto");
          pw.println("} bind def");

          pw.println();
          

          // On ecrit le nom du volume et celui du proprietaire
          pw.println("/Times-Roman findfont 13 scalefont setfont");
          pw.println("/x0 {2 cm} def");
          pw.println("/y0 {15 cm} def");
          pw.println("x0 y0 moveto");
          pw.println("(" + nomVolume + ") newline");
          pw.println("/x0 {7 cm} def");
          pw.println("/y0 {15 cm} def");
          pw.println("x0 y0 moveto");
          pw.println("(" + nomProprietaire + ") newline");

          pw.println();

          // On ecrit les noms des fichiers de premier niveau dans l'arborescence
          // Maximun 27 noms

          pw.println("/Times-Roman findfont 9 scalefont setfont");
          pw.println("/x0 {3 cm} def");
          pw.println("/y0 {14.4 cm} def");
          pw.println("x0 y0 moveto");
          
          pw.println();
          
          
          for (int i = 0; ((i < 28) && (i < premierNiveau.size())); i++) {
            String chaine = (String) premierNiveau.elementAt(i);
            pw.print("(");
            if (chaine.length() < 60)
              pw.print(chaine);
            else 
              pw.print(chaine.substring(0, 60));
            pw.println(") newline");
          }

          // Tous les noms sont ecrits, on ejecte la page.
          pw.println("showpage                  %% Sortie de la page");

          pw.println();
          // Et on genere la seconde page

          pw.println("newpath");
          pw.println("1 cm 1 cm moveto          %% Contour du livret");
          pw.println("1 cm 25.30 cm lineto");
          pw.println("13.15 cm 25.30 cm lineto");
          pw.println("13.15 cm 1 cm lineto");
          pw.println("closepath");
          
          pw.println();
          
          pw.println("1 cm 13.15 cm  moveto     %% Pliure");
          pw.println("13.15 cm 13.15 cm lineto");
          pw.println("stroke");
          
          pw.println();
          
          // On met un petit "jCD"...

          pw.println("/Times-Roman findfont 12 scalefont setfont");
          pw.println("/x0 {12 cm} def");
          pw.println("/y0 {13.5 cm} def");
          pw.println("x0 y0 moveto");
          pw.println("(jCD) newline");
          
          pw.println();
          
          // On ecrit le nom du volume et celui du proprietaire
          pw.println("/Times-Roman findfont 13 scalefont setfont");
          pw.println("/x0 {2 cm} def");
          pw.println("/y0 {12.5 cm} def");
          pw.println("x0 y0 moveto");
          pw.println("(" + nomVolume + ") newline");
          pw.println("/x0 {7 cm} def");
          pw.println("/y0 {12.5 cm} def");
          pw.println("x0 y0 moveto");
          pw.println("(" + nomProprietaire + ") newline");

          pw.println();

          // Meme procede que pour la page precedente.
          // Dans la prochaine version du code, la partie generee plus
          // haut sera definie dans un bloc '/text { ... } def', pour
          // ne pas effectuer une seconde fois cette boucle.
          // On ecrit les noms des fichiers de premier niveau dans l'arborescence
          // Maximun 27 noms
          
          pw.println("/Times-Roman findfont 8 scalefont setfont");
          pw.println("/x0 {3 cm} def");
          pw.println("/y0 {11.9 cm} def");
          pw.println("x0 y0 moveto");
          
          pw.println();
          
          
          for (int i = 0; ((i < 28) && (i < premierNiveau.size())); i++) {
            String chaine = (String) premierNiveau.elementAt(i);
            pw.print("(");
            if (chaine.length() < 60)
              pw.print(chaine);
            else 
              pw.print(chaine.substring(0, 60));
            pw.println(") newline");
          }
          
          pw.println();

          // Et on fait la page garde
          
          pw.println("/Times-Roman findfont 15 scalefont setfont");
          pw.println("0.71 cm 4.60 cm translate %% Face avant de la pochette");
          pw.println("45 rotate");
          pw.println("2 1 scale");
          pw.println("newpath");
          pw.println("3.5 cm 5.5 cm moveto");
          pw.println("(" + nomVolumeLong + ") true charpath");
          pw.println("0.5 setlinewidth");
          pw.println("0.4 setgray");
          
          pw.println("stroke");


          // Tous les noms sont ecrits, on ejecte la page.
          pw.println("showpage                  %% Ejection");
          
          


          
        } catch (IOException e) {
          // A gerer
        } finally {
          try {
            pw.close();
          } catch(Exception e) {
            // A gerer
          }
        }
  }
}
 


