import javax.swing.*;
import javax.swing.border.*;
import javax.swing.ImageIcon;
import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;

public class JResultat extends JFrame implements ActionListener {
  private JList dataList;
  private CheminVolume[] data;
  
  public JResultat(ArrayList cheminVolume)  {
    // liste : tableau d'objets VolumeChemin
    super("jCD - Recherche : resultats");
    
  
    
    //JPanel utilise pour mettre un bord
    JPanel jp = new JPanel();
    jp.setBorder(new EmptyBorder(8, 8, 8, 8));
    jp.setLayout(new BoxLayout(jp, BoxLayout.Y_AXIS));
    jp.setBorder(new LineBorder(Color.black, 1));
    
    JLabel jl = new JLabel("Resulats de la recherche", 
			   new ImageIcon("images/binocular.gif"), 0);
    jp.add(jl);
        
    // On cree une JList qui affiche les resultats de la recherche
    int size = cheminVolume.size();
    data = new CheminVolume[size];
    for (int i = 0 ; i < size ; i++) {
      data[i] = (CheminVolume)cheminVolume.get(i);
    }
    
    dataList = new JList(data);
    dataList.addMouseListener(mouseListener);
    JScrollPane scrollPane = new JScrollPane(dataList);
    
    getContentPane().add(jp, BorderLayout.NORTH);
    getContentPane().add(scrollPane);
    
    FermeurDeFenetre fermeurFenetre = new FermeurDeFenetre();
    addWindowListener(fermeurFenetre);
  
    setSize(313, 250);
    //setResizable(false);
  }
    
  MouseListener mouseListener = new MouseAdapter() {
    public void mouseClicked(MouseEvent e) {
      try {
	if (e.getClickCount() == 1) {
	  int index = dataList.locationToIndex(e.getPoint());
	  jCD.JCombo.jcb.setSelectedItem(data[index].getNomVolume());
	}
      } catch (Exception e2) { 
	// click dans la fenetre
      }
    }
  };

  /**
   * Traitement des actions
   */
  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
  }
  
  /** 
   * Une classe interne pour gerer la fermeture de la fenetre
   */
  class FermeurDeFenetre extends WindowAdapter {
    public void windowClosing(WindowEvent event){
      dispose();
    }
  }
}






