import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import javax.swing.ImageIcon;
import javax.accessibility.*;
import java.awt.BorderLayout;
import java.awt.GridLayout;


/** Frame qui affiche une succinte aide en ligne */

public class JAide extends JFrame implements ActionListener {
  
  public JAide() {
    super("jCD - Aide");

    setSize(560, 510);
    setResizable(false);

    JPanel jp = new JPanel();
    jp.setBorder(new EmptyBorder(7, 7, 7, 7));
    jp.setLayout(new BoxLayout(jp, BoxLayout.Y_AXIS));
    
    String text =
    "      Voici une brieve aide en ligne de jCD dans laquelle vous trouverez un\n" +
    "   renseignement sur les principales fonctionnalites de jCD.\n\n" +
    "      Dans le menu Fichier : \"Actualiser\" recharge le CD courant, \"Rechercher\"\n" +
    "   propose deux types de recherches : l'une dans le CD courant et l'autre dans \n" +
    "   la base de donnees entiere. \"Apercu avant impression\" lance un visualiseur PS\n" +
    "   pour se rendre compte de ce que sera la jaquette imprimee et \"Imprimer\" confirme\n" +
    "   l'envie de l'utilisateur. L'option \"Quitter\" est resolument intuitive\n\n" +
    "      Dans le second menu se trouvent deux options qui permettent le rajout, ainsi \n" +
    "   que le retrait de CD dans la base de donnees de l'utilisateur. La fonction \n" +
    "   \"Sauvegarde\" sauve la base de donnees.\n\n" +
    "      Le menu \"Options\" autorise la redefinition des divers chemins utiles a jCD.\n\n" +
    "      Enfin le menu \"Aide\" propose un affichage de cette fenetre ainsi que celui de\n" +
    "   fenetre \"A Propos\".\n\n" +
    "      Les plus utiles de ces fonctions sont disponibles a partir de la barre d'outils.\n\n";

    
    JTextArea jta = new JTextArea(text);
    jta.setEditable(false);
    jp.add(jta);
    
    JPanel panelBouton = new JPanel();
    JButton bouton = new JButton(" OK ");
    bouton.addActionListener(this);
    bouton.setActionCommand("ok");
    panelBouton.add(bouton);
    
    jp.add(panelBouton);

    getContentPane().add(jp);
 
    FermeurDeFenetre fermeurFenetre = new FermeurDeFenetre();
    addWindowListener(fermeurFenetre);
    
  }


  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    
    if (command.equals("ok"))
      dispose();
  }
  


 /** 
   * Une classe interne pour gerer la fermeture de la fenetre
   */
  class FermeurDeFenetre extends WindowAdapter {
    public void windowClosing(WindowEvent event){
      dispose();
    }
  }
  
}
