package japie.util;

import java.util.*;

public class View {

    private Collection donnees;
    private Critere critere;

    public View(Critere critere){
        this(null, critere);
    }

    public View(Collection donnees){
        this(donnees, null);
    }

    public View(Collection donnees, Critere critere){
        setCritere(critere);
        setDonnees(donnees);
    }

    public void setCritere(Critere critere){
        this.critere=critere;
    }

    public void setDonnees(Collection donnees){
        this.donnees=donnees;
    }

    public Critere getCritere(){
        return  this.critere;
    }

    public Collection getDonnees(){
        return this.donnees;
    }


    /* Java-like mode */
    public Collection getView(){
        return getView(this.donnees);
    }


    public Collection getView(Collection donnees){
        if (donnees == null)
            return null;
        else if (this.critere == null) 
            return donnees;
        else {
            Collection result=new Vector();
            Object[] temp=donnees.toArray();
            for (int i=0 ; i < donnees.size() ; i++)
                if (this.critere.repond(temp[i]))
                    result.add(temp[i]);
            return result;
        }
    }


    /* Moulinette-mode */
    public static Collection getView(Collection donnees, Critere critere){
        View v = new View(donnees, critere);
        return v.getView();
    }
}









