package japie.swing.table;

import java.util.*;
import javax.swing.event.*;
import javax.swing.table.*;

import japie.util.*;

public class ViewTableModel extends NormalTableModel {

    protected Vector baseDataVector;
    protected Critere critere;

    public ViewTableModel() {
        super();
    }

    public ViewTableModel(Vector data, Object[] columnNames, Critere critere) {
        super(data, columnNames);
        this.baseDataVector = data;
        this.critere = critere;
    }

    public ViewTableModel(Vector data, Vector columnNames, Critere critere) {
        super(data, columnNames);
        this.baseDataVector = data;
        this.critere = critere;
    }


    public Critere getCritere() {
        return this.critere;
    }
    public void setCritere(Critere critere) {
        if (this.critere != critere) {
            this.critere = critere;
            newDataAvailable(new TableModelEvent(this));
        }
    }
    public Vector getBaseDataVector() {
        return this.baseDataVector;
    }


    /* Surcharges ----------------- ----------------- ----------------- */

    public void setDataVector(Vector newData) {
        this.baseDataVector = newData;
        newDataAvailable(new TableModelEvent(this));
    }


    public void newDataAvailable(TableModelEvent t) {
        this.dataVector = new Vector(View.getView(this.baseDataVector, this.critere));
        super.newDataAvailable(t); 
    }


    /* Attention, changement par rapport  la vue !!! */
    public void setValueAt(Object aValue, int row, int column) {
        Vector ligneAChanger = getRow(row);
        Vector nouvelleLigne = (Vector)ligneAChanger.clone();
        nouvelleLigne.set(column, aValue);
        this.dataVector.set(this.baseDataVector.indexOf(ligneAChanger),
                            nouvelleLigne);
        newDataAvailable(new TableModelEvent(this));
    }





    /* Fait passer  ----------------- ----------------- ----------------- */

    public Class getColumnClass(int columnIndex) {
        return super.getColumnClass(columnIndex);
    }

    public Vector getColumnIdentifiers() {
        return super.getColumnIdentifiers();
    }



    /* Main ------- ----------------- ----------------- ----------------- */

    public static void main(String[] args) {
        String[] titres = {"Presence", "Nom", "Prenom", "ID"};

        Vector donnees = new Vector(2);
        Object[] temp = {Boolean.TRUE, "van Leeuwen", "Marc", new Integer(1000)};
        japie.util.VectorPlus ligne = new japie.util.VectorPlus(temp);

        donnees.add(ligne);

        ViewTableModel tm = new ViewTableModel(donnees, titres, null);
        javax.swing.JTable t = new javax.swing.JTable(tm);
       	tm.addTableModelListener(t);
        javax.swing.JScrollPane sp = new javax.swing.JScrollPane(t);

        javax.swing.JFrame f = new javax.swing.JFrame("Test tableau");
        f.getContentPane().add(sp);
        f.pack();
        f.setVisible(true);
    }
}



