package japie.swing.table;

import java.util.*;
import javax.swing.event.*;


public class SortedTableModel extends NormalTableModel {

    protected Comparator comparator;

    public SortedTableModel() {
        super();
    }
    

    public SortedTableModel(Vector data, Object[] columnNames, Comparator comparator) {
        super(data, columnNames);
        setComparator(comparator);
    }

    public SortedTableModel(Vector data, Vector columnNames, Comparator comparator) {
        super(data, columnNames);
        setComparator(comparator);
    }



    public Comparator setComparator(Comparator newComparator) {
        Comparator oldComparator = this.comparator;
        this.comparator = newComparator;
        newDataAvailable(new TableModelEvent(this));
        return oldComparator;
    }

    public Comparator getComparator() {
        return this.comparator;
    }


    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        newDataAvailable(new TableModelEvent(this));
    }

    public void newDataAvailable(TableModelEvent e) {
        if (this.comparator != null)
            Collections.sort(this.dataVector, this.comparator);
        super.newDataAvailable(e);
    }



/*

    public static void main(String[] args) {
        String[] titres = {"Presence","Nom", "Prnom", "ID"};

        Vector donnees = new Vector();
        { Object[] temp = {Boolean.TRUE, "van Leeuwen", "Marc", new Integer(1000)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.FALSE, "del Gatto", "Eric", new Integer(1001)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.FALSE, "Pouille", "Delphine", new Integer(1002)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.TRUE, "Mondelo", "Caroline", new Integer(1003)};
        donnees.add(new japie.util.VectorPlus(temp)); }
                    
        SortedTableModel tm = new SortedTableModel(donnees, titres, null);
        javax.swing.JTable t = new javax.swing.JTable(tm);
       	tm.addTableModelListener(t);
        javax.swing.JScrollPane sp = new javax.swing.JScrollPane(t);

        javax.swing.JFrame f = new javax.swing.JFrame("Test tableau");
        f.getContentPane().add(sp);
        f.pack();
        f.setVisible(true);
        Comparator[] comps = {new data.comparators.NumeroComparatorAsc(),
                              new data.comparators.NumeroComparatorDesc(),
                              new data.comparators.NomComparatorAsc(),
                              new data.comparators.NomComparatorDesc(),
                              new data.comparators.PrenomComparatorAsc(),
                              new data.comparators.PrenomComparatorDesc(),
                              new data.comparators.PresenceComparatorAsc(),
                              new data.comparators.PresenceComparatorDesc()};
        int i=0;
        while(true) {
            tm.setComparator(comps[i]);
            f.setTitle(comps[i].getClass().getName());
            try { Thread.sleep(5000); }catch(InterruptedException e) {}
            i++;
            if ((i % comps.length) == 0) i=0;
        }
    }
    */
}



