package japie.swing.table;

import java.util.*;
import javax.swing.event.*;
import javax.swing.table.*;


public class NormalTableModel extends DefaultTableModel {

    public NormalTableModel() {
        super();
    }

    public NormalTableModel(Vector data, Object[] columnNames) {
        super(columnNames, 0);
        setDataVector(data);
    }

    public NormalTableModel(Vector data, Vector columnNames) {
        super(data, columnNames);
    }

    public Class getColumnClass(int columnIndex) {
        return getValueAt(0, columnIndex).getClass();
    }

    public Vector getColumnIdentifiers() {
        return columnIdentifiers;
    }

    public Vector getRow(int row) {
        return (Vector)this.dataVector.get(row);
    }


    /**  Replaces the current dataVector instance variable with the new 
         Vector of rows, <i>newData</i>, keeping the same column names.
         is adjusted to match the number of columns in the columnIdentifiers
         instance variable either by truncating the Vector if it is too long, 
         or adding null values if it is too short.
         @param newData The new data vector.
    */
    public void setDataVector(Vector newData) {
        //        setDataVector(newData, getColumnIdentifiers());
        dataVector = newData;
        super.newDataAvailable(new TableModelEvent(this));
    }


    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
    }


    public static void main(String[] args) {
        String[] titres = {"Presence", "Nom", "Prenom", "ID"};

        Vector donnees = new Vector(2);
        Object[] temp = {Boolean.TRUE, "van Leeuwen", "Marc", new Integer(1000)};
        japie.util.VectorPlus ligne = new japie.util.VectorPlus(temp);

        donnees.add(ligne);

        NormalTableModel tm = new NormalTableModel(donnees, titres);
        javax.swing.JTable t = new javax.swing.JTable(tm);
       	tm.addTableModelListener(t);
        javax.swing.JScrollPane sp = new javax.swing.JScrollPane(t);

        javax.swing.JFrame f = new javax.swing.JFrame("Test tableau");
        f.getContentPane().add(sp);
        f.pack();
        f.setVisible(true);
    }
}



