package japie;

import java.io.*;
import java.util.*;
import PothFinderCommon.*;


public class IDCache extends Thread {

    private final String PROPERTYNAME = "CachedValue";
    private String filename = null;
    private int value;
    private boolean shouldRun = true;
    private Properties p = new Properties();

    public IDCache(String filename) {
        this.filename = filename;
        this.setPriority(MIN_PRIORITY);
        try {
            FileInputStream in = new FileInputStream(filename);
            p.load(in);
            setValue(Integer.parseInt(p.getProperty(PROPERTYNAME,"0")));
            in.close();
        }catch(IOException e){} // on s'en fiche si ca rate, on a des valeurs par defaut. 
    }

    public final int getValue() {
        return value;
    }

    public final synchronized void setValue(int newValue) {
        value = newValue;
    }

    public final synchronized int addOneAndGet() {
        int result = getValue()+1;
        setValue(result);
        return result;
    }

    /** Met  jour le cache sur disque */
    public final void run() {
        shouldRun = true;
        while(shouldRun) {
            _updateDisk();
            try {
                sleep(25000);
            } catch(Exception e) {}
        }
    }

    public final synchronized void stopWritingToDisk() {
        shouldRun = false;
    }

    private final synchronized void _updateDisk() {
        try {
            p.setProperty(PROPERTYNAME, Integer.toString(getValue()));
            FileOutputStream out = new FileOutputStream(filename);
            p.store(out,
                    " !!!!! THIS FILE IS AUTOMATICALY UPDATED, PLEASE DON'T MODIFY !!!!");
            out.close();
        }catch(Exception e) {
            System.err.println("Exception bizarre");
        }
    }
    
} // IDCache




