package PothFinderServer;

import java.rmi.*;
import java.rmi.server.*;
import java.net.*;
import java.util.*;

import PothFinderCommon.*;
import japie.*;
import japie.util.*;


/*
 * UsersToInformImpl.java
 */
/**
 *    Implmentation de l'interface UsersToInformInterface.
 *  
 * Gre la liste contenant les listes des personnes  prvenir 
 * en cas de (d)connection d'un utilisateur observ.
 *
 *
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */



public class UsersToInformServer extends UnicastRemoteObject 
    implements UsersToInformInterface {


    private static final String SERVERNAME = "UsersToInformServer";
    private static final String CONFIG_FILENAME = SERVERNAME+".conf";

    protected static boolean verbose = false; /* bavard pour les messages sur System.out */
    protected static Properties config=null;  /* La configuration de ce serveur */

    private Hashtable liste = null;
    private LoggedUsersInterface luServer = null;


    public static void main(String args[]) { 
	try {
	    if (args[0].equals("-v")) verbose=true;
	}catch(Exception e) {}
	try {
	    printVerbose("Starting..."); 
	    new UsersToInformServer();
	    System.out.println("\n"+SERVERNAME+": ==> READY !\n");
        } catch (Exception e) {
	    System.err.println("\n"+SERVERNAME+" ERROR: "+
                               e.getMessage()+"\n"); 
            if (verbose)
                e.printStackTrace();
            Pause.pause();
            System.exit(1);
        }
    }
    


    // -- Constructor(s) --------------- ---------------- ---------------- ----------------

    /** Cre un une nouvelle liste (vide) de gens  prevenir. */
    public UsersToInformServer() throws Exception {
        super();
        installSecurityManager();
        printVerbose("Loading configuration file");
	config = NiceProperties.load(CONFIG_FILENAME);

        findSubServers();
        liste = new Hashtable(100);

	printVerbose("Binding in registry..."); 
	Naming.rebind(SERVERNAME, this); 
    }






    // -- RMI accessible methods -------------- -------------------------- -------------------

    
    /** Ajoute l'utilisateur de userID 'whoToInform'  la liste de 
        chaque utilisateur de la liste 'peopleToMonitor'.
        Si cette liste n'existe pas encore, elle est cree. */
    public synchronized void add(Integer whoToInform, HashSet peopleToMonitor) {
        try {
            Iterator iter = peopleToMonitor.iterator();
            while(iter.hasNext()) {
                /* On rcupre le userID suivant dans la liste 'whoToMonitor'
                   et on ajoute whoToInform  sa liste */
                add(whoToInform, (Integer)iter.next());
            }
        } catch (Exception e) { e.printStackTrace(); }           
        System.out.println(liste);            
    }


    /** Ajoute l'utilisateur d'ID 'whoToInform'  la liste de 
        l'utilisateur d'ID 'WhoToMonitor'.
        Si cette liste n'existe pas encore, elle est cree. */
    public synchronized void add(Integer whoToInform, Integer whoToMonitor) {
        // on rcupre la liste... pour la modifier.
        try {
            if (whoToInform != whoToMonitor) {
                HashSet temp = (HashSet)liste.get(whoToMonitor);
                if (temp == null) {
                    temp = new HashSet(3);
                }
                temp.add(whoToInform);
                liste.put(whoToMonitor, temp);
            }
        } catch (Exception e) { e.printStackTrace(); }
    }



    /** Enlve l'utilisateur de userID 'whoToInform' de la liste de chaque  
        utilisateur de la liste 'WhoToMonitor'.
        Si cette liste devient vide, alors elle est supprime. */
    public void remove(Integer whoToInform, HashSet peopleToMonitor) {
        try {
            Iterator iter = peopleToMonitor.iterator();
            while(iter.hasNext()) {
                /* On rcupre le userID suivant dans la liste 'whoToMonitor'
                   et on enleve whoToInform  sa liste */
                remove(whoToInform, (Integer)iter.next());
            }
        } catch (Exception e) { e.printStackTrace(); }
        System.out.println(liste);            
    }



    /** Enlve l'utilisateur de userID 'whoToInform' de la liste de 
        l'utilisateur d'ID 'WhoToMonitor'.
        Si cette liste devient vide, alors elle est supprime. */
    public synchronized void remove(Integer whoToInform, Integer whoToMonitor) {
        // on rcupre la liste... pour la modifier.
        try {
            HashSet temp = (HashSet)liste.remove(whoToMonitor);
            if (temp != null) {
                temp.remove(whoToInform);
                if (!temp.isEmpty())
                    liste.put(whoToMonitor, temp);
            }
        } catch(Exception e) { e.printStackTrace(); }
    }

    

    /** Quelqu'un s'est connect, il va donc falloir prvenir ses potes qui l'attendent
        de son arrive. C'est donc ce que fais cette mthode.
        PENDING: Rendre plus robuste et tudier ce qui doit vraiment tre synchronis*/
    public synchronized void hasJoined(Integer userID) {
        try {
            HashSet whoToInformSet = (HashSet)liste.get(userID);
            if (whoToInformSet != null) {
                Object[] whoToInform = whoToInformSet.toArray();
                for (int i=0; i < whoToInform.length; i++) {
                    String clientAddress = null;
                    try {
                        clientAddress = luServer.lookFor((Integer)whoToInform[i]);
                    }catch(RemoteException re) {    
                        /* ERREUR GRAVE */
                        closeService("Could not find the 'Logged Users' sub-server anymore");
                    }
                    if (clientAddress != null) {                  
                        try {
                            ServerAvailableMethods client = (ServerAvailableMethods)
                                Naming.lookup("//"+clientAddress+"/P@thFinderClient");
                            client.hasJoined(userID);
                        }catch(Exception e) {
                            printVerbose("WARNING: impossible de trouver le client declare sur "+
                                         clientAddress);
                            e.printStackTrace();
                            try {
                                luServer.logOff((Integer)whoToInform[i]);
                            }catch(RemoteException re) { 
                                /* ERREUR GRAVE */
                                closeService("Could not find the 'Logged Users' "+
                                             "sub-server anymore");
                            }
                        }
                    }else{ /* tiens, on est sens prvenir une personne qui n'est pas logge,
                              il y a visiblement inconsistence d'informations dans la liste 
                              des gens a informer, on va corriger cela */
                        printVerbose("WARNING: Inconsistence !!!");
                        remove((Integer)whoToInform[i], userID);
                    }
                }
            }
        }catch(Exception e) {
            e.printStackTrace();
        }
    }

      

    /** Quelqu'un s'est dconnect, il va donc falloir prvenir ses potes qui le 
        voient de son absence. C'est donc ce que fais cette mthode.
        PENDING: Rendre plus robuste et tudier ce qui doit vraiment tre synchronis */
    public void hasLeft(Integer userID) {
        try {
            HashSet whoToInformSet = (HashSet)liste.get(userID);
            if (whoToInformSet != null) {
                Object[] whoToInform = whoToInformSet.toArray();
                for (int i=0; i < whoToInform.length; i++) {
                    String clientAddress = null;
                    try {
                        clientAddress = luServer.lookFor((Integer)whoToInform[i]);
                    }catch(Exception ex) {    
                        /* ERREUR GRAVE */
                        closeService("Could not find the 'Logged Users' sub-server anymore");
                    }
                    if (clientAddress != null) {                  
                        try {
                            ServerAvailableMethods client = (ServerAvailableMethods)
                                Naming.lookup("//"+clientAddress+"/P@thFinderClient");
                            client.hasLeft(userID);
                        }catch(Exception e) {
                            printVerbose("WARNING: impossible de trouver le client declare sur "+
                                         clientAddress);
                            try {
                                luServer.logOff((Integer)whoToInform[i]);
                            }catch(RemoteException re) { 
                                /* ERREUR GRAVE */
                                closeService("Could not find the 'Logged Users' sub-server anymore");
                            }
                        }
                    }else{ /* tiens, on est sens prvenir une personne qui n'est pas logge,
                              il y a visiblement inconsistence d'informations dans la liste 
                              des gens a informer, on va corriger cela */
                        remove((Integer)whoToInform[i], userID);
                    }
                }
            }
        }catch(Exception e) {
            e.printStackTrace();
        }
    }




    // -- Miscellanous ------------- ------------------- -------------------- -------------------

    public final void closeService(String msg) {
        // PENDING: Rendre plus robuste ici, de sorte  prvenir les autres serveurs. !
        System.err.println(SERVERNAME+" ERROR: "+msg);
        System.err.flush();
        myFinalize();
        System.exit(20);
    }

    public void myFinalize() {
        try {
            Naming.unbind(SERVERNAME);
        }catch(Exception e) {}
    }







    // -- Private method(s) -------- ------------------- -------------------- -------------------


    /** Boucle pour attendre que le sous-serveur atendu soit inscrit dans le rmiregistry.
        PENDING: attente infinie, mettre un timeout */
    private void findSubServers() {
        boolean OK = false;

	printVerbose("Waiting for the 'Logged Users' sub-server...");
        do {
            try {
                luServer=(LoggedUsersInterface)
                    Naming.lookup("//"+
                                  config.getProperty("LoggedUsersServerLocation")+
                                  "/LoggedUsersServer");
                OK = true;
                printVerbose("=> Found LoggedUsersServer on host '"+
                             config.getProperty("LoggedUsersServerLocation")+"'.");
            } catch(Exception e) { 
                try {
                    Thread.sleep(1000);
                }catch(Exception e2) {}
            }
        } while (!OK);
    }



    // DEBUG DEBUG DEBUG DEBUG
    private Hashtable dump() {
        return liste;
    }





    /** Installation du gestionnaire de scurit si necessaire */
    private void installSecurityManager() {
        if (System.getSecurityManager() == null) { 
            printVerbose("Installing a security manager..."); 
            System.setSecurityManager(new RMISecurityManager()); 
        }
    }



    private static void printVerbose(String s) {
        if (verbose) {
            System.out.println(SERVERNAME+": "+s);
            System.out.flush();
        }
    }









//      public static void main(String[] args) {
//          try {
//              UsersToInformServer usersToInformList = new UsersToInformServer();
//              HashSet DelphineList = new HashSet(3);
//              HashSet MarcoList = new HashSet(3);
//              HashSet EricList = new HashSet(3);

//              Integer Delphine = new Integer(1000);
//              Integer Marco = new Integer(1001);
//              Integer Eric = new Integer(1002);

//              DelphineList.add(Marco);
//              MarcoList.add(Delphine);
//              MarcoList.add(Eric);
//              EricList.add(Marco);
//              EricList.add(Delphine);

//              System.out.println("\nDelphine ("+Delphine+") est interessee par: "+DelphineList);
//              System.out.println("Marco    ("+Marco+") est interesse par:  "+MarcoList);
//              System.out.println("Eric     ("+Eric+") est interesse par:  "+EricList);

//              usersToInformList.add(EricList, Eric);
//              usersToInformList.add(MarcoList, Marco);
//              usersToInformList.add(DelphineList, Delphine);

//              System.out.println("\nCeci donne la representation suivante:\n"+ 
//                                 usersToInformList.getListe());

//              System.out.println("\nOn enleve les utilisateurs de "+Delphine+" : "+DelphineList);
//              usersToInformList.remove(DelphineList, Delphine);

//              System.out.println("\nCeci donne la representation suivante:\n"+ 
//                                 usersToInformList.getListe());


//              System.out.println("\nOn enleve les utilisateurs de "+Marco+" : "+MarcoList);
//              usersToInformList.remove(MarcoList, Marco);

//              System.out.println("\nCeci donne la representation suivante:\n"+ 
//                                 usersToInformList.getListe());


//          } catch(Exception e) {e.printStackTrace();}
//      }

} // UsersToInformServer
