package PothFinderServer;

import java.rmi.*;
import java.rmi.server.*;
import java.util.*;
import java.io.*;
import java.net.*;
import PothFinderCommon.*;
import japie.*;
import japie.util.*;


/* 
 * MainServer.java
 */
/**
 *
 *
 *
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */


public class MainServer extends UnicastRemoteObject
    implements ClientAvailableMethods {
    
    public static final String SERVERNAME = "MainServer";
    public static final String CONFIG_FILENAME = SERVERNAME+".conf";
    
    protected static boolean verbose = false; /* bavard pour les messages sur System.out */
    protected static Properties config=null;  /* La configuration de ce serveur */



    private ExistingUsersInterface     euServer  = null;   // serveur de gens existants
    private LoggedUsersInterface       luServer  = null;   // serveur de gens connects.
    private UsersToInformInterface     utiServer = null;   // serveur de gens  prvenir.
    




    // -- Main --------- --------------- ---------------- ---------------- ----------------

    public static void main(String args[]) { 
	try {
	    if (args[0].equals("-v")) verbose=true;
	}catch(Exception e) {}
	try {
	    printVerbose("Starting..."); 
	    MainServer ms = new MainServer();
	    System.out.println("\n"+SERVERNAME+": ==> READY !\n");
            Thread.sleep(20*1000);
            ms.logIn(new User(7, new Password(), InetAddress.getLocalHost()), new HashSet());
        } catch (Exception e) {
	    System.err.println("\n"+SERVERNAME+" ERROR: "+
                               e.getMessage()+"\n"); 
            if (verbose)
                e.printStackTrace();
            Pause.pause();
            System.exit(1);
        }
    }
    



    
    // -- Constructor(s) --------------- ---------------- ---------------- ----------------
    
    public MainServer() throws Exception {
        super();
        installSecurityManager();
        printVerbose("Loading configuration file");
	config = NiceProperties.load(CONFIG_FILENAME);

        /* On veut d'abord trouver tous les serveurs avant de...*/
	findSubServers();
        /* ... se dclarer au registre */
	printVerbose("Binding in registry..."); 
	Naming.rebind("P@thFinderServer", this); 
    }





    // -- RMI accessible methods -------------- -------------------------- -------------------


    /** Permet  un utilisateur de dire "Je suis l !" (de se logger).
        @exception PothFinderCommon.PFSecurityException Le mot de passe de 
        l'utilisateur 'me' est incorrect.
        @exception PothFinderCommon.PFConnectException Il y a un problme de 
        Connect  l'un des sous-serveurs et le service est donc (temporairement) 
        indisponible.
    */
    public HashSet logIn(User me, HashSet contactList) throws PFSecurityException {
printVerbose("(login) ("+me.getUserID()+"->"+contactList+")");
        try {
            euServer.verifyIdentity(me);
            luServer.logIn(me);
            Integer me2 = new Integer(me.getUserID());
            utiServer.hasJoined(me2); // Prvient les autres de son arrive
            utiServer.add(me2, contactList); // Ajoute l'observation de sa contact List
            HashSet result = luServer.areLogged(contactList);
printVerbose("Currently logged from contact list = "+result);
            return result;
        } catch(RemoteException re){
            /* ERREUR GRAVE */
            closeService("Could not find one of the sub-servers anymore");
        }catch(PFSecurityException pfse){
            throw pfse;
        } catch(Exception e) {
            e.printStackTrace();
        }
        return null;
    }





    /** Permet  l'utilisateur de signaler qu'il dsire se dlogger. */
    public void logOff(User me) throws PFSecurityException {
printVerbose("(logoff) ("+me.getUserID()+")");
        try {
            euServer.verifyIdentity(me);
            Integer me2 = new Integer(me.getUserID());
            utiServer.hasLeft(me2);
	    luServer.logOff(me2);
        }catch(RemoteException re) {
            /* ERREUR GRAVE */
            closeService("Could not find one of the sub-servers anymore");
        }catch(PFSecurityException pfse){
            throw pfse;
        }catch(Exception e) {
            e.printStackTrace();
        }
    }


    public String lookFor(User me, Integer poteID) 
        throws PFSecurityException, PFQueryException {
printVerbose("(lookFor) ("+me.getUserID()+"->"+poteID+")");
	try {
	    euServer.verifyIdentity(me);
            if (luServer.isLogged(me.getUserID()))
                return luServer.lookFor(poteID);
            else 
                throw new PFQueryException("You're not logged, man !");
	}catch(RemoteException re){
            /* ERREUR GRAVE */
            closeService("Could not find one of the sub-servers anymore");
        }catch(PFSecurityException pfse){
            throw pfse;
        }catch(PFQueryException pfqe){
            throw pfqe;
	}catch(Exception e) {
            printVerbose("LookFor exception");
            e.printStackTrace();
        }
        return null;
    }
    
    
    public boolean isLogged(User me, Integer poteID) 
        throws PFSecurityException, PFQueryException {
printVerbose("(isLogged) ("+me.getUserID()+"->"+poteID+")");
	try {
	    euServer.verifyIdentity(me);
            if (luServer.isLogged(me.getUserID())) {
                printVerbose("il est logge le gars "+me.getUserID());            
                return luServer.isLogged(poteID);
            }else {
                printVerbose("il n'est pas logge le gars "+me.getUserID());            
                throw new PFQueryException("You're not logged, man !");
            }
	}catch(RemoteException re){
            /* ERREUR GRAVE */
            closeService("Could not find one of the sub-servers anymore");
        }catch(PFSecurityException pfse){
            throw pfse;
        }catch(PFQueryException pfqe){
            throw pfqe;
	}catch(Exception e) {
            printVerbose("JE SUIS LA");   
            e.printStackTrace();
        }
        return false;
    }



    
    public User createUser(UserProperties me) throws PFQueryException {
printVerbose("(create) ("+me+")");
        try {
            return euServer.createUser(me);
        }catch(RemoteException re){
            /* ERREUR GRAVE */
            closeService("Could not find one of the sub-servers anymore");
        }catch(PFQueryException pfqe){
            throw pfqe;
        }catch(Exception e) {
            e.printStackTrace();
        }
        return null;
    }
        


    public boolean addToContactList(User me, Integer poteID) 
        throws PFSecurityException, PFQueryException {
printVerbose("(add2CL) ("+me.getUserID()+"->"+poteID+")");
        try {
            euServer.verifyIdentity(me);
            Integer myID = new Integer(me.getUserID());
            if (luServer.isLogged(myID)) {
                utiServer.add(myID, poteID);
                return luServer.isLogged(poteID);
            }else 
                throw new PFQueryException("You're not logged, man !");
        }catch(RemoteException re) {
            /* ERREUR GRAVE */
            closeService("Could not find one of the sub-servers anymore");
        }catch(PFSecurityException pfse){
            throw pfse;
        }catch(PFQueryException pfqe){
            throw pfqe;
        }catch(Exception e) {
            e.printStackTrace();
        }
        return false;
    }


    public void removeFromContactList(User me, Integer poteID) 
        throws PFSecurityException, PFQueryException {
printVerbose("(removeFromCL) ("+me.getUserID()+"->"+poteID+")");
        try {
            euServer.verifyIdentity(me);
            Integer myID = new Integer(me.getUserID());
            if (luServer.isLogged(myID))
                utiServer.remove(myID, poteID);
            else 
                throw new PFQueryException("You're not logged, man !");
        }catch(RemoteException re) {
            /* ERREUR GRAVE */
            closeService("Could not find one of the sub-servers anymore");
        }catch(PFSecurityException pfse){
            throw pfse;
        }catch(PFQueryException pfqe){
            throw pfqe;
        }catch(Exception e) {
            e.printStackTrace();
        }
    }



    // -- Miscellanous ------------- ------------------- -------------------- -------------------

    public final void closeService(String msg) {
        System.err.println(SERVERNAME+" ERROR: "+msg);
        System.err.flush(); 
        try {
            euServer.closeService("Received from "+SERVERNAME+": "+msg);
        }catch(Exception e) {}
        try {
            luServer.closeService("Received from "+SERVERNAME+": "+msg);
        }catch(Exception e) {}
        try {
            utiServer.closeService("Received from "+SERVERNAME+": "+msg);
        }catch(Exception e) {}
        myFinalize();
        System.exit(20);
    }


    public void myFinalize() {
        try {
            Naming.unbind("P@thFinderServer");
        }catch(Exception e) {}
    }





    // -- Private method(s) -------- ------------------- -------------------- -------------------

    /** Boucle pour attendre que le sous-serveur atendu soit inscrit dans le rmiregistry.
        PENDING: attente infinie, mettre un timeout */
    private void findSubServers() {
        int leftToWaitFor = 3;

	printVerbose("Waiting for the "+leftToWaitFor+" sub-servers...");
        do {
            if (euServer == null) {
                try {
                    euServer=(ExistingUsersInterface)
                        Naming.lookup("//"+config.getProperty("ExistingUsersServerLocation")+
                                      "/ExistingUsersServer");
                    leftToWaitFor--;
                    printVerbose("=> Found ExistingUsersServer on host '"+
                                 config.getProperty("ExistingUsersServerLocation")+"'."); 
                } catch(Exception e) { 
                    euServer = null; // pour etre sur.
                }
            }
            if (luServer == null) {
                try {
                    luServer=(LoggedUsersInterface)
                        Naming.lookup("//"+config.getProperty("LoggedUsersServerLocation")+
                                      "/LoggedUsersServer");
                    leftToWaitFor--;
                    printVerbose("=> Found LoggedUsersServer on host '"+
                                 config.getProperty("LoggedUsersServerLocation")+"'.");
                } catch(Exception e) { 
                    luServer = null; // pour etre sur;
                }
            }
            if (utiServer == null) {
                try {
                    utiServer=(UsersToInformInterface)
                        Naming.lookup("//"+config.getProperty("UsersToInformServerLocation")+
                                      "/UsersToInformServer");
                    leftToWaitFor--;
                    printVerbose("=> Found UsersToInformServer on host '"+
                                 config.getProperty("UsersToInformServerLocation")+"'.");
                } catch(Exception e) { 
                    utiServer = null; // pour etre sur.
                }
            }
        } while (leftToWaitFor > 0);
    }



    /** Installation du gestionnaire de scurit si necessaire */
    private void installSecurityManager() {
        if (System.getSecurityManager() == null) { 
            printVerbose("Installing a security manager..."); 
            System.setSecurityManager(new RMISecurityManager()); 
        }
    }



    private static void printVerbose(String s) {
        if (verbose) {
            System.out.println(SERVERNAME+": "+s);
            System.out.flush();
        }
    }



} // MainServer
