package PothFinderServer;

/*
 * LoggedUsersImpl.java
 */
/**
 *    Implmentation de l'interface LoggedUsersInterface.
 *  
 *
 *  Gre la liste de personnes "logges"<BR>
 *  Accessible  d'autres serveurs PothFinder.
 *  Les mthodes d'accs  cette liste peuvent tre lances par RMI.<BR>
 *
 *
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */

import java.rmi.*;
import java.rmi.server.*;
import java.net.*;
import java.util.*;
import japie.*;
import japie.util.*;
import PothFinderCommon.*;


// pending: Stocker un port d'ecoute !


public class LoggedUsersServer extends UnicastRemoteObject 
    implements LoggedUsersInterface {

    private static final String SERVERNAME      = "LoggedUsersServer";
    private static final String CONFIG_FILENAME = SERVERNAME+".conf";
    
    protected static boolean verbose   = false; /* bavard pour les messages sur System.out */
    protected static Properties config = null;  /* La configuration de ce serveur */
    
    private Hashtable liste;



    // -- Main --------- --------------- ---------------- ---------------- ----------------

    public static void main(String args[]) { 
	try {
	    if (args[0].equals("-v")) verbose=true;
	}catch(Exception e) {}
	try {
	    printVerbose("Starting..."); 
	    new LoggedUsersServer();
	    System.out.println("\n"+SERVERNAME+": ==> READY !\n");
        } catch (Exception e) {
	    System.err.println("\n"+SERVERNAME+" ERROR: "+
                               e.getMessage()+"\n"); 
            if (verbose)
                e.printStackTrace();
            Pause.pause();
            System.exit(1);
        }
    }
    



    // -- Constructor(s) --------------- ---------------- ---------------- ----------------

    /** Cre un une nouvelle liste (vide) de connects. */
    public LoggedUsersServer() throws Exception {
        super();
        installSecurityManager();
        printVerbose("Loading configuration file");
	config = NiceProperties.load(CONFIG_FILENAME);

        liste = new Hashtable(100);

	printVerbose("Binding in registry..."); 
	Naming.rebind(SERVERNAME, this); 
    }



    
    // -- RMI accessible methods -------------- -------------------------- -------------------


    /** Renvoie l'adresse IP de l'utilisateur d'ID 'userID' s'il est connect, null sinon. */
    public String lookFor(int userID) {
        return lookFor(new Integer(userID));
    }

    /** Renvoie l'adresse IP de l'utilisateur d'ID 'userID' s'il est connect, null sinon. */
    public String lookFor(Integer userID) {
printVerbose("(lookFor) ("+userID+")");
        try {
            return ((InetAddress)liste.get(userID)).getHostAddress();
        }catch(Exception e) {
            //printVerbose("addresse non remplie");            
        }
        return null;
    }


    /** Renvoie la liste des gens loggs parmis ceux passs en paramtre.
        Cette fonction sert lorsque l'on veut savoir  un moment prcis 
        si des connaissances sont logges, par exemple lorsque l'on se connecte.*/
    public HashSet areLogged(HashSet peopleToLookFor) {
printVerbose("(areLogged) ("+peopleToLookFor+")");
        HashSet result = new HashSet(0);
        try {
            Object[] people = peopleToLookFor.toArray();
            for (int i=0; i < people.length; i++) {
                if (isLogged((Integer)(people[i])))
                    result.add((Integer)people[i]);
            }
        }catch(Exception e) {
            e.printStackTrace();
        }
        return result;
    }


    /** Renvoie vrai si l'utilisateur d'ID 'userID' est actuellement connect, faux sinon */
    public boolean isLogged(int userID) {
        return isLogged(new Integer(userID));
    }

    /** Renvoie vrai si l'utilisateur d'ID 'userID' est actuellement connect, faux sinon */
    public boolean isLogged(Integer userID) {
printVerbose("(isLogged) ("+userID+")");
        try {
            return liste.containsKey(userID);
        }catch(Exception e) {
            e.printStackTrace();
        }
        return false;
    }



    /** Ajoute un utilisateur dans la liste des utilisateurs connects.
        <BR>Si un utilisateur de mme ID est dj connect, alors son adresse est mise  jour */
    public void logIn(User me) {
printVerbose("(logIn) ("+me.getUserID()+")");
        try { 
            liste.put(new Integer(me.getUserID()), me.getCurrentAddress());
            System.err.println("LOG: Utilisateur "+me.getUserID()+" rajoute ("+(new Date())+")");
        }catch(Exception e) {
            e.printStackTrace();
        }
printVerbose("Liste des gens logges ("+new Date()+"): "+liste);
    }


    /** Enlve l'utilisateur de la liste des utilisateurs connects.
        <BR>Si celui-ci n'est pas connect, alors rien ne sera fait. */
    public void logOff(Integer me) {
printVerbose("(logOff) ("+me+")");
        try {
            liste.remove(me);
        }catch(Exception e) {
            e.printStackTrace();
        }
        System.err.println("LOG: Utilisateur "+me+" enleve ("+(new Date())+")");
printVerbose("Liste des gens logges: "+liste);
    }
 
    // -- Miscellanous ------------- ------------------- -------------------- -------------------

    public final void closeService(String msg) {
        // PENDING: Rendre plus robuste ici, de sorte  prvenir les autres serveurs. !
        System.err.println(SERVERNAME+" ERROR: "+msg);
        System.err.flush();
        myFinalize();
        System.exit(20);
    }

    public void myFinalize() {
        try {
            Naming.unbind(SERVERNAME);
        }catch(Exception e) {}
    }







    // -- Private method(s) -------- ------------------- -------------------- -------------------

    private static void printVerbose(String s) {
        if (verbose) {
            System.out.println(SERVERNAME+": "+s);
            System.out.flush();
        }
    }


    /** Installation du gestionnaire de scurit si necessaire */
    private void installSecurityManager() {
        if (System.getSecurityManager() == null) { 
            printVerbose("Installing a security manager..."); 
            System.setSecurityManager(new RMISecurityManager()); 
        }
    }


    // DEBUG DEBUG DEBUG DEBUG
    private Hashtable dump() {
        return liste;
    }

} // LoggedUsersInterface
