package PothFinderServer;

/*
 * ExistingUsersImpl.java
 */
/**
 *    Implmentation de l'interface ExistingUsers.
 *  
 *
 *  Gre la liste de personnes existantes (inscrites)<BR>
 *  Accessible  d'autres serveurs P@thFinder.
 *  Les mthodes d'accs  cette liste peuvent tre lances par RMI.<BR>
 *
 *
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */


import java.rmi.*;
import java.rmi.server.*;
import java.net.*;
import java.io.*;
import java.util.*;
import java.sql.*;
import PothFinderCommon.*;
import japie.*;
import japie.util.*;


public class ExistingUsersServer extends UnicastRemoteObject 
    implements ExistingUsersInterface {

    private static final String SERVERNAME = "ExistingUsersServer";
    private static final String CONFIG_FILENAME = SERVERNAME+".conf";

    protected static boolean verbose = false; /* bavard pour les messages sur System.out */
    protected static Properties config=null;  /* La configuration de ce serveur */

    private Connection con = null;
    private Statement stmt = null;
    private int lastIDUsed = 0; /* DO NOT ACCESS DIRECTLY, 
                                   use getter and setter instead !
                                   Pending: Should become a class */



    // -- Main --------- --------------- ---------------- ---------------- ----------------

    public static void main(String args[]) { 
	try {
	    if (args[0].equals("-v")) verbose=true;
	}catch(Exception e) {}
	try {
	    printVerbose("Starting..."); 
	    new ExistingUsersServer();
	    System.out.println("\n"+SERVERNAME+": ==> READY !\n");
        } catch (Exception e) {
	    System.err.println("\n"+SERVERNAME+" ERROR: "+
                               e.getMessage()+"\n"); 
            if (verbose)
                e.printStackTrace();
            Pause.pause();
            System.exit(1);
        }
    }
    



    // -- Constructor(s) --------------- ---------------- ---------------- ----------------

    public ExistingUsersServer() throws Exception {
        super();
        installSecurityManager();
        printVerbose("Loading configuration file");
	config = NiceProperties.load(CONFIG_FILENAME);

        printVerbose("Connecting to database...");
#ifndef DEBUG
        connectToDatabase();
#endif
        printVerbose("Initializing database parameters...");
#ifndef DEBUG
        update_LastIDUsed_FromDatabase();
#else
        setLastIDUsed(4);
#endif
        printVerbose("Last allocated userID = "+getLastIDUsed());
        printVerbose("Binding in registry..."); 
	Naming.rebind(SERVERNAME, this); 
    }





    // -- RMI accessible methods -------------- -------------------------- -------------------

    public void verifyIdentity(User me) throws RemoteException, PFSecurityException {
printVerbose("(verify) ("+me.getUserID()+")");
#ifdef DEBUG

#else
        try {
            ResultSet rs = 
                stmt.executeQuery("SELECT Password FROM Users WHERE ID = "+me.getUserID());
            if (! rs.isBeforeFirst()) 
                throw new PFSecurityException("No such user: "+me.getUserID());
            rs.next();  // on se place sur le premier resultat (le seul en principe).
            if (me.getPassword().getInt() != rs.getInt("Password"))
                throw new PFSecurityException("Incorrect password provided for "+me.getUserID());
	}catch(Exception e) {
            throw new PFSecurityException("Incorrect password provided for "+me.getUserID());
        }
#endif
    }





    public User createUser(UserProperties me) throws RemoteException, PFQueryException {
printVerbose("(create) ("+me+")");
        Password p;
        User u;
        try {
            p = new Password();
            u = new User(addOneAndGet_lastIDUsed(),p);
            int result = 
#ifdef DEBUG
                1;
#else
                stmt.executeUpdate("INSERT INTO Users "+
                                   "VALUES("+u.getUserID()+","+p.getInt()+",'"+
                                   me.getPrenom()+"','"+me.getNom()+"','"+me.getMail()+"')");
#endif
            if (result == 1) 
                return u;
            else throw new PFQueryException("This user already exists");
        }catch(Exception e) {
            throw new PFQueryException(e);
        }
    }




    // -- lastUsed ID Stuff ----------- ------------------ ----------------- -------------------

    private synchronized int addOneAndGet_lastIDUsed() {
        return setLastIDUsed(1+getLastIDUsed());
    }
    
    private final synchronized int setLastIDUsed(int newValue) {
        return (lastIDUsed = newValue);
    }

    private final synchronized int getLastIDUsed() {
        return lastIDUsed;
    }


    private final void update_LastIDUsed_FromDatabase() throws PFFatalException {
        try {
            ResultSet rs = 
                stmt.executeQuery("SELECT ID FROM Users"); // Argghhh: toute la base !!!
            rs.last();
            setLastIDUsed(rs.getInt("ID"));
        } catch(Exception e) {
            throw new PFFatalException("Error while calculating last userID used.",e);
        }
    }





    // -- Miscellanous ------------- ------------------- -------------------- -------------------

    public final void closeService(String msg) {
        // PENDING: Rendre plus robuste ici, de sorte  prvenir les autres serveurs. !
        System.err.println(SERVERNAME+" ERROR: "+msg);
        System.err.flush();
        myFinalize();
        System.exit(20);
    }

    public void myFinalize() {
        try {
            Naming.unbind(SERVERNAME);
        }catch(Exception e) {}
    }








    // -- Private method(s) -------- ------------------- -------------------- -------------------

    private static void printVerbose(String s) {
        if (verbose) {
            System.out.println(SERVERNAME+": "+s);
            System.out.flush();
        }
    }


    /** Installation du gestionnaire de scurit si necessaire */
    private void installSecurityManager() {
        if (System.getSecurityManager() == null) { 
            printVerbose("Installing a security manager..."); 
            System.setSecurityManager(new RMISecurityManager()); 
        }
    }



    private final void connectToDatabase() throws PFFatalException {
        try {
            Class.forName(config.getProperty("JDBCDriver"));
        } catch(Exception e) {
            throw new PFFatalException("Error while loading the JDBC Driver ("+e.getMessage()+").");
        }
        try {
            con = DriverManager.
                getConnection("jdbc:"+
                              config.getProperty("JDBCDriverCode")+":"+config.getProperty("DataBaseURL"),
                              config.getProperty("DataBaseUser"),
                              config.getProperty("DataBasePassword"));
            stmt = con.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE, 
                                       ResultSet.CONCUR_READ_ONLY);
        } catch(SQLException sqle) {
            throw new PFFatalException("Connection to database ("+
                                       config.getProperty("DataBaseURL")+
                                       ") Failed.");
        }
    }

} // ExistingUsersServer





//                              --==   E O F  ==--

