package PothFinderCommon;

import java.rmi.*;
import java.rmi.server.*;
import java.net.*;
import java.util.*;

/*
 * UsersToInformInterface.java
 */
/**
 *    Interface UsersToInformInterface.
 *  
 * Gre la liste contenant les listes des personnes  prvenir 
 * en cas de connection d'un utilisateur en particulier.
 *
 *
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */


public interface UsersToInformInterface extends Remote {
    
    /** Ajoute l'utilisateur de userID 'whoToInform'  la liste de 
        chaque utilisateur de la liste 'WhoToMonitor'.
        Si cette liste n'existe pas encore, elle est cree. */
    public void add(Integer whoToInform, HashSet peopleToMonitor) throws RemoteException;
        
        /** Ajoute l'utilisateur d'ID 'whoToInform'  la liste de 
            l'utilisateur d'ID 'WhoToMonitor'.
            Si cette liste n'existe pas encore, elle est cree. */
    public void add(Integer whoToInform, Integer whoToMonitor)    throws RemoteException;



    /** Enlve l'utilisateur de userID 'whoToInform' de la liste de chaque  
        utilisateur de la liste 'WhoToMonitor'.
        Si cette liste devient vide, alors elle est supprime. */
    public void remove(Integer whoToRemove, HashSet peopleToMonitor) throws RemoteException;

    /** Enlve l'utilisateur de userID 'whoToInform' de la liste de 
        l'utilisateur d'ID 'WhoToMonitor'.
        Si cette liste devient vide, alors elle est supprime. */
    public void remove(Integer whoToRemove, Integer whoToMonitor)    throws RemoteException;

    public void hasJoined(Integer userID) throws RemoteException;

    public void hasLeft(Integer userID) throws RemoteException;


    /** Quitte le sous-serveur */
    public void closeService(String message) throws RemoteException;

} // UsersToInformInterface
