package PothFinderCommon;

import java.net.*;
import java.util.*;
import java.io.*;

/* 
 * User.java 
 */
/**
 *
 *  Classe grant la rprsentation et la manipulation 
 *  d'un utilisateur P@thFinder(tm).
 *  
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */

public class User implements Serializable {
    private int ID;
    private Password password;
    private InetAddress currentAddress;

    public static final String FILENAME = "User.pth";


    public User(int userID) {
        this(userID, null, null);
    }
    public User(int userID, Password password) {
        this(userID, password, null);
    }
    public User(int userID, InetAddress address) {
        this(userID, null, address);
    }
    public User(int userID, Password password, InetAddress address) {
        setUserID(userID);
        setPassword(password);
        setCurrentAddress(address);
    }


    public int getUserID() {
        return ID;
    }    
    public Password getPassword() {
        return password;
    }
    public InetAddress getCurrentAddress() {
        return currentAddress;
    }


    public void setUserID(int ID) {
        this.ID = ID;
    }    
    public void setPassword(Password password) {
        this.password = password;
    }
    public void setCurrentAddress(InetAddress currentAddress) {
        this.currentAddress = currentAddress;
    }



    public static User load(String filename) throws PFIOException {
        try {
            ObjectInputStream p = new ObjectInputStream(new FileInputStream(filename));
            User result = (User)p.readObject();
            p.close();
            return result;
        }catch(Exception e) {
            throw new PFIOException(e);
        }
    }

    public void save(String filename) throws PFIOException {
        try {
            ObjectOutputStream p = new ObjectOutputStream(new FileOutputStream(filename));
            p.writeObject(this);
            p.close();
        }catch(Exception e) {
            throw new PFIOException(e);
        }
    }



    public String toString() {
        return ("User : "+getUserID()+" | Password: "+getPassword()+" | Address: "+getCurrentAddress());
    }

    public static void main(String[] args) throws Exception {
        User u = User.load("toto");
        /*        User u = new User(1000, new Password(), null);
                  u.save("toto"); */
        System.out.println(u);
    }

} // User


