package PothFinderCommon;


/**
 * PFException.java
 *
 *
 * Created: Mon Dec 21 20:59:21 1998
 *
 * @author 
 * @version
 */

public class PFException extends Exception {

    private Exception nested = null;

    public PFException() {
        super();
    }

    public PFException(Exception e) {
        this();
        nested = e;
    }

    public PFException(String s) {
        super(s);
    }

    public PFException(String s, Exception e) {
        this(s);
        nested = e;
    }

    public void printStackTrace() {
        super.printStackTrace();
        System.out.println(" nested exception is : ");
        nested.printStackTrace();
    }

    public String getFullMessage() {
        String result = super.getMessage();
        if (result != null) 
            return (result+" nested exception message is : "+nested.getMessage());
        else return null;
    }

    public String getNestedMessage() {
        return nested.getMessage();
    }

    public String toString() {
        return (super.toString()+" nested exception is : "+nested.toString());
    }

} // PFException


