package PothFinderCommon;

import java.rmi.*;
import java.net.*;
import java.util.*;

/* 
 * LoggedUsersInterface.java 
 */
/**
 *
 *  Gre la liste de gens loggs et leut adresse IP.
 *
 *
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */


public interface LoggedUsersInterface extends Remote {
    
    /** Renvoie l'adresse IP de l'utilisateur userID s'il est connect, null sinon. */
    public String lookFor(int userID) throws RemoteException;


    /** Renvoie l'adresse IP de l'utilisateur userID s'il est connect, null sinon. */
    public String lookFor(Integer userID) throws RemoteException;


    /** Renvoie vrai si l'utilisateur d'ID 'userID' est actuellement connect, faux sinon */
    public boolean isLogged(int userID) throws RemoteException;

    /** Renvoie vrai si l'utilisateur d'ID 'userID' est actuellement connect, faux sinon */
    public boolean isLogged(Integer userID) throws RemoteException;

    /** Renvoie la liste des gens actuellement loggs parmi cux passs en paramtre */
    public HashSet areLogged(HashSet peopleToLookFor) throws RemoteException;

    /** Ajoute un utilisateur dans la liste des utilisateurs connects.
        <BR>Si un utilisateur de mme ID est dj connect, alors son adresse est mise  jour */
    public void logIn(User me) throws RemoteException;


    /** Enlve l'utilisateur de la liste des utilisateurs connects.
        <BR>Si celui-ci n'est pas connect, alors rien ne sera fait. */
    public void logOff(Integer me) throws RemoteException;


    /** Quitte le sous-serveur */
    public void closeService(String message) throws RemoteException;

} // LoggedUsersInterface

