/* 
 * ClientAvailableMethods.java 
 */
/**
 *
 *  Point d'entre du serveur P@thFinder(tm).
 *  Grce  ces methodes, les clients P@thFinder(tm) peuvent 
 *  effectuer toutes les actions dont ils ont besoins.
 *
 *
 * @author Marc van Leeuwen (mvanleeu@clio.unice.fr)
 * @author Eric del Gatto   (edelgatt@clio.unice.fr)
 *
 * @version 0.1
 */
package PothFinderCommon;

import java.rmi.*;
import java.net.*;
import java.util.*;
import java.io.*;


public interface ClientAvailableMethods extends Remote {
    


    /** Permet  un utilisateur de dire "Je suis l !" (de se logger).
        Renvoie la liste des gens parmi la contactList qui sont actuellement l.
        @param me  (User) : Les coordonnes de l'utilisateur voulant se logger.
        @exception PFSecurityException : L'authentification de l'utilisateur 'me' 
        a chou, le mot de passe doit tre mauvais ou bien l'utilisateur n'existe pas. */
    public HashSet logIn(User me, HashSet contactList) throws RemoteException, PFSecurityException;

    /** Permet  l'utilisateur de signaler qu'il dsire se dlogger. */
    public void logOff(User me) throws RemoteException, PFSecurityException;
    

    public User createUser(UserProperties me) throws RemoteException, PFQueryException;


    public boolean addToContactList(User me, Integer pote) 
        throws RemoteException, PFSecurityException, PFQueryException;

    public void removeFromContactList(User me, Integer pote) 
        throws RemoteException, PFSecurityException, PFQueryException;
    

    public String lookFor(User me, Integer poteID) 
        throws RemoteException, PFSecurityException, PFQueryException;

    public boolean isLogged(User me, Integer poteID) 
        throws RemoteException, PFSecurityException, PFQueryException;


} // ClientAvailableMethods


