package PothFinderClient.gui.table;

import java.util.Vector;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

import japie.swing.table.*;
import PothFinderClient.*;



public class Tableau extends JTable {


    //CHANGED    public Tableau(SortedTableModel tableauModel) {
    public Tableau(ViewTableModel tableauModel) {
        super(tableauModel);
        //CHANGED        final SortedTableModel t = tableauModel;
        final ViewTableModel t = tableauModel;

        setShowVerticalLines(false);             // on cache les lignes verticales
        setColumnSelectionAllowed(false); 
        setDefaultRenderer(Boolean.class, new BooleanRenderer(true));
        setUpIntegerEditor();
        this.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.getColumnModel().getColumn(3).setPreferredWidth(25);

        /*        getTableHeader().addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                int viewColumn = getColumnModel().getColumnIndexAtX(e.getX()); 
                int column = convertColumnIndexToModel(viewColumn); 
                if(e.getClickCount() == 1 && column != -1) {
                    //System.out.println("Sorting ..."); 
                    int shiftPressed = e.getModifiers() & InputEvent.SHIFT_MASK; 
                    t.setComparator(PothFinderClient.UserData.Comparator(column, shiftPressed==0));
                }
            }
            });*/
    }
    

    public UserData getSelectedLine() {
        ListSelectionModel lsm = getSelectionModel();
        if (lsm.isSelectionEmpty())
            return null;
        else
            return (UserData)(((TableauModel)getModel()).getRow(lsm.getMinSelectionIndex()));
    }
    
        
    
    public static void main(String[] args) {
        String[] titres = {"Presence", "Nom", "Prenom", "ID"};

        Vector donnees = new Vector();
        { Object[] temp = {Boolean.TRUE, "van Leeuwen", "Marc", new Integer(1000)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.FALSE, "del Gatto", "Eric", new Integer(1001)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.FALSE, "Pouille", "Delphine", new Integer(1002)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.TRUE, "Mondelo", "Caroline", new Integer(1003)};
        donnees.add(new japie.util.VectorPlus(temp)); }
                    

        TableauModel tm = new TableauModel(donnees, titres, null);
        Tableau t = new Tableau(tm);
       	tm.addTableModelListener(t);
        JFrame f = new JFrame("Test tableau");
        f.getContentPane().add(new JScrollPane(t));
        t.setPreferredScrollableViewportSize(new Dimension(350, 70));
        f.pack();
        f.setVisible(true);
    }








    //-------------------------------EDITION INTEGER--------------------------------------------

    private void setUpIntegerEditor() {
        //Set up the editor for the integer cells.

	final WholeNumberField integerField = new WholeNumberField(0,3);
	integerField.setHorizontalAlignment(WholeNumberField.RIGHT);
	
	DefaultCellEditor integerEditor = 
	    new DefaultCellEditor(integerField) {
                public Object getCellEditorValue() {
                    return new Integer(integerField.getValue());
                }
            };
        setDefaultEditor(Integer.class, integerEditor);
    }


}
