package PothFinderClient.gui.table;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;

public class BooleanRenderer 
    extends JLabel
    implements TableCellRenderer {

    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;
    
    public BooleanRenderer(boolean isBordered) {
        super();
        this.isBordered = isBordered;
        setOpaque(true); //MUST do this for background to show up.
    }
    
    public Component getTableCellRendererComponent(JTable table, Object present,boolean isSelected, 
                                                   boolean hasFocus,int row, int column) {
        if (((Boolean)present).equals(Boolean.TRUE))
            setBackground(Color.green);
        else 
            setBackground(Color.red);
        if (isBordered) {
            if (isSelected) {
                if (selectedBorder == null) {
                    selectedBorder = BorderFactory.createMatteBorder(2,5,2,5,
                                                                     table.getSelectionBackground());
                }
                setBorder(selectedBorder);
            } else {
                if (unselectedBorder == null) {
                    unselectedBorder = BorderFactory.createMatteBorder(2,5,2,5,
                                                                       table.getBackground());
                }
                setBorder(unselectedBorder);
            }
        }
        return this;
    }
}

