package PothFinderClient.gui;

import PothFinderClient.gui.table.*;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;

public class OngletPrincipalUI extends JPanel {
    private JButton ajouterPoteButton,supprimerPoteButton;                 // boutons
    private JToolBar PlugInsBar =new JToolBar(JToolBar.VERTICAL);           // Panel contenant les boutons
    private Tableau tableau;

    public OngletPrincipalUI(Tableau tableau) {
        JRadioButton voirTous, voirPresents, voirAbsents;  // radio boutons
	JPanel changementsListe =new JPanel();              // Panel contenant les boutons ajout suppression liste
	JPanel typeconn = new JPanel();                     // Panel contenant les radio boutons
	JPanel rb = new JPanel();                           // Panel contenant les radio boutons et boutons
	JPanel texttableau = new JPanel();                  // Panel contenant le texte et la scroll barre

	GridBagConstraints gbc = new GridBagConstraints();  // informations pour GridBagLayout
	ButtonGroup cbg = new ButtonGroup();                // informations pour le groupe radio bouton


	//---------------------------------------------------------------------------------------------
        // PlugInsBar: Barre contenant les boutons des diffrents plug-ins

        PlugInsBar.setFloatable(false);

	//---------------------------------------------------------------------------------------------
        // add/suppr elements au tableau

	changementsListe.setLayout(new GridBagLayout());// on place les boutons avec GridBagLayout

	gbc.gridx = 0;                                  // colonne 0
	gbc.gridy = 1;                                  // ligne 1
	gbc.insets = new Insets(5,5,5,5);               // 5 espaces tout au tour
  	gbc.fill = GridBagConstraints.HORIZONTAL;       // etendre au max a l'horizontal
        ajouterPoteButton = new JButton("Ajouter");           // bouton d'ajout d'un pote  la liste observe.
        ajouterPoteButton.setToolTipText("Ajouter un pote a la liste des potes observes");
	changementsListe.add(ajouterPoteButton,gbc);          // Ajoute le bouton de suppression au panel

	gbc.gridx = 0;                                  // colonne 0
	gbc.gridy = 2;                                  // ligne 2
	gbc.insets = new Insets(5,5,5,5);               // 5 espaces tout au tour
  	gbc.fill = GridBagConstraints.HORIZONTAL;       // etendre au max a l'horizontal
        supprimerPoteButton = new JButton("Supprimer");// bouton de suppression d'un pote de la liste observe.
        supprimerPoteButton.setToolTipText("Enleve le pote selectionne de la liste des potes observes");
	changementsListe.add(supprimerPoteButton ,gbc);       // Ajoute le bouton de suppression au panel

        //        changementsListe.setBackground(Color.white);


	//---------------------------------------------------------------------------------------------
        // differentes vues du tableau
        this.tableau = tableau;

	typeconn.setLayout(new GridLayout(3,1));          // on place les radio boutons avec GridLayout 1l & 3c

	voirTous = new JRadioButton("Tous",true);         // radio bouton "tous" valide
	cbg.add(voirTous);                                // tous appartient au group "cbg"
	typeconn.add(voirTous);                           // on le place dans le Panel
       	voirTous.addActionListener(new EcouteurVoirTous());// action a effectuer quand bouton appuye
	voirPresents = new JRadioButton("Connectes",false);  // radio bouton "present" valide
	cbg.add(voirPresents);                            // presents appartient au group "cbg"
	typeconn.add(voirPresents);                       // on le place dans le Panel
	voirPresents.addActionListener(new EcouteurVoirPresents());// action a effectuer quand bouton appuye
	voirAbsents = new JRadioButton("Deconnectes",false);  // radio bouton "absent" invalide
	cbg.add(voirAbsents);                            // absents appartient au group "cbg"
	typeconn.add(voirAbsents);                       // on le place dans le Panel
	voirAbsents.addActionListener(new EcouteurVoirAbsents());// action a effectuer quand bouton appuye

        /*        voirTous.setBackground(Color.white);
                  voirPresents.setBackground(Color.white);
                  voirAbsents.setBackground(Color.white);
        */

	//---------------------------------------------------------------------------------------------
        // Actions sur le tableau

	rb.setLayout(new GridBagLayout());

	gbc.gridx = 0;                                  // colonne 0
	gbc.gridy = 0;                                  // ligne 0
      	gbc.weighty = 100;                              // poids de la fenetre dans la colonne 100 
	gbc.weightx = 15;                               // poids de la fenetre dans la ligne 15
	gbc.insets = new Insets(5,5,5,5);               // 5 espaces tout au tour
  	gbc.fill = GridBagConstraints.HORIZONTAL;       // etendre au max a l'horizontal
	rb.add(changementsListe,gbc);

	gbc.gridx = 1;                                  // colonne 1
	gbc.gridy = 0;                                  // ligne 0
      	gbc.weighty = 100;                              // poids de la fenetre dans la colonne 100 
	gbc.weightx = 20;                               // poids de la fenetre dans la ligne 20
	gbc.insets = new Insets(5,5,5,5);               // 5 espaces tout au tour
  	gbc.fill = GridBagConstraints.HORIZONTAL;       // etendre au max a l'horizontal
	rb.add(typeconn,gbc);

        //rb.setBackground(Color.white);

        TitledBorder titleborder;
        titleborder = BorderFactory.createTitledBorder("Gestion de la liste des contacts");
        titleborder.setTitleJustification(TitledBorder.LEFT);
        rb.setBorder(titleborder);


	//---------------------------------------------------------------------------------------------
        // Emplacement general 
	
	setLayout(new GridBagLayout());         // on place les Panels avec GridBagLayout
	
	gbc.gridx = 0;                          // colonne 0
	gbc.gridy = -1;                         // ligne ?
      	gbc.weighty = 100;                      // poids de la fenetre dans la colonne 100 
	gbc.weightx = 10;                       // poids de la fenetre dans la ligne 10
  	gbc.fill = GridBagConstraints.VERTICAL; // etendre au max a la Vertical
        //        PlugInsBar.setBackground(Color.white);
	add(PlugInsBar,gbc);               // on ajoute le Panel

	gbc.gridx = 1;                          // colonne 1
	gbc.gridy = 1;                          // ligne 1
	gbc.weighty = 10;                       // poids sur de la fenetre dans la colonne 10
	gbc.insets = new Insets(0,10,0,10);     // 10 espaces a gauche et 10 a droite
  	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	add(rb,gbc);                            // on ajoute le Panel

	gbc.gridx = 1;                          // colonne 1
	gbc.gridy = 0;                          // ligne 0
	gbc.weightx = 50;                       // poids sur de la fenetre dans la ligne 50
	gbc.weighty = 50;                       // poids sur de la fenetre dans la colonne 50
	gbc.insets = new Insets(0,0,0,0);       // aucun espace au tour
  	gbc.fill = GridBagConstraints.BOTH;     // etendre au maximum de tout cote
	add(new JScrollPane(tableau),gbc);      // on ajoute le Panel

        tableau.setPreferredScrollableViewportSize(new Dimension(300, 100));
        //        setBackground(Color.white);
    }


    /** 
        La Fleme vous savez ....
     */
    public void addPlugInButton(JButton representationIconographiqueDuBoutonSansBlaBla) {
        PlugInsBar.add(representationIconographiqueDuBoutonSansBlaBla);
    }
        

    public void setEcouteurAjouterPoteButton(ActionListener actionListener) { 
	ajouterPoteButton.addActionListener(actionListener);
    }


    public void setEcouteurSupprimerPoteButton(ActionListener actionListener) {
	supprimerPoteButton.addActionListener(actionListener);
    }






    //------------------------------ECOUTEURS  DES VUES-----------------------------------------

    private class EcouteurVoirTous implements ActionListener {
	public void actionPerformed(ActionEvent e) {
                        ((TableauModel)(tableau.getModel())).setCritere(null);
        }
    }


    private class EcouteurVoirPresents implements ActionListener {
	public void actionPerformed(ActionEvent e) {
                        ((TableauModel)(tableau.getModel())).setCritere(new CriterePresents());
        }
    }

    private class EcouteurVoirAbsents implements ActionListener {
	public void actionPerformed(ActionEvent e) {
                        ((TableauModel)(tableau.getModel())).setCritere(new CritereAbsents());
        }
    }





    public static void main(String[] args) {
        JFrame frame = new JFrame("DialogDemo");
        String[] titres = {"Presence", "Nom", "Prenom", "ID"};
        Vector donnees = new Vector();
        { Object[] temp = {Boolean.TRUE, "van Leeuwen", "Marc", new Integer(1000)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.FALSE, "del Gatto", "Eric", new Integer(1001)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.FALSE, "Pouille", "Delphine", new Integer(1002)};
        donnees.add(new japie.util.VectorPlus(temp)); }
        { Object[] temp = {Boolean.TRUE, "Mondello", "Caroline", new Integer(1003)};
        donnees.add(new japie.util.VectorPlus(temp)); }
 
        TableauModel tableauModel=new TableauModel(donnees, titres,  null);
        Tableau tableau = new Tableau(tableauModel);
        
        frame.getContentPane().add(new OngletPrincipalUI(tableau));
        
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });

        frame.pack();
        frame.setVisible(true);
    }

}
