package PothFinderClient.gui;


import PothFinderCommon.*;

import PothFinderClient.*;
import PothFinderClient.gui.table.*;
import PothFinderClient.gui.plugins.*;

import javax.swing.*;
import java.awt.event.*;
import java.net.*;
import java.util.*;

public class OngletPrincipal extends Onglet{

    private Client client;
    private OngletPrincipalUI ui;
    private Tableau tableau;


    public OngletPrincipal(PothFinder pere){
	super(pere);
        TableauModel tableauModel;

	try {
	    client = Client.load();
	}catch(PFIOException notLoaded) {

	    /* Rajouter pop up indiquant que doit etre connecte pour ca */
	    String string1 = "Continuer l'inscription";
	    String string2 = "Quitter";
	    Object[] options = {string1, string2};
	    int n = JOptionPane.showOptionDialog(null,
						 "Il semblerait que vous ne soyez pas encore inscrit(e).\n"+
                                                 "On va donc s'en occuper tout de suite. \n"+
                                                 "Soyez juste sur(e) que vous etes actuellement connecte \n"+
                                                 "a internet...",
						 "Vous voulez bien vous inscrire ?",
						 JOptionPane.YES_NO_OPTION,
						 JOptionPane.QUESTION_MESSAGE,
						 null,     //don't use a custom Icon
						 options,  //the titles of buttons
						 string1); //the title of the default button
	    if (n == JOptionPane.NO_OPTION) {
		System.exit(0);
	    } else if (n == JOptionPane.YES_OPTION) {
		InscriptionUI inscription = new InscriptionUI();
		try {
		    client = new Client(inscription.getResult());
		}catch(PFIOException configFileMissing){
		    JOptionPane.
                        showMessageDialog(null, "Le fichier de configuration '"+Client.CONFIG_FILENAME+
                                          "' n'a pas pu etre trouve,\n rendant l'inscription impossible.\n"+ 
                                          "Ce fichier contient diverses informations necessaires lors \n"+
                                          "de l'inscription comme par exemple l'adresse internet du "+
                                          "serveur...\n Vous devrez donc peut-etre reinstaller "+
                                          "P@thFinder(tm).",
                                          "message d'erreur", JOptionPane.ERROR_MESSAGE);
		    System.exit(1);
		}catch(PFQueryException alreadyExists){
		    JOptionPane.
                        showMessageDialog(null, "Desole, mais il semblerait que les informations que vous "+
                                          "venez de saisir correspondent deja a quelqu'un sur le serveur sur "+
                                          "lequel vous vous inscrivez, et il ne peut en rester qu'un. \n",
                                          "message d'erreur", JOptionPane.ERROR_MESSAGE);
		    System.exit(1);
		}catch(PFConnectException unableToConnect){
		    JOptionPane.
                        showMessageDialog(null, "Le serveur P@thFinder(tm) tel que specifie dans le fichier \n"+
                                          "de configuration '"+Client.CONFIG_FILENAME+"' n'a pu etre trouve.\n"+
                                          "Verifier donc si vous etes bien connecte a Internet, sinon \n"+
                                          "retournez-vous contre le vendeur du logiciel (comment-ca il est "+
                                          " gratuit ? )",
                                          "message d'erreur", JOptionPane.ERROR_MESSAGE);
		    System.exit(1);
                }catch(Exception e) {
		    JOptionPane.
                        showMessageDialog(null, "Aie, cette erreur ("+e.getMessage()+") n'a pas ete \n"+
                                          "prevue par les programmeurs. vivement qu'il trouvent le bug et \n"+
                                          "qu'ils fournissent dare dare une version qui marche un peu mieux !",
                                          "message d'erreur", JOptionPane.ERROR_MESSAGE);
		    System.exit(1);
                }

                // L'inscription s'est bien passe , on va essayer de sauvegarder !
                try {
                    client.save();
                }catch(PFIOException saveWilly) {
		    JOptionPane.
                        showMessageDialog(null, "Alors que vous aviez vayayament rempli le formulaire,\n"+
                                          "alors que le serveur a ete trouve,\n"+
                                          "alors que personne sur ce serveur ne s'appelle comme vous,\n"+
                                          "alors que ce meme serveur a bien voulu vous inscrire\n"+
                                          "vous voila betement arrete(e) par une erreur de sauvegarde...\n"+
                                          "Les fichiers contenant vos parametres ("+Client.DATA_FILENAME+
                                          ".xxxx...) n'ont pu etre \nsauvegardes sur le disque, "+
                                          "et l'inscription a donc globalement rate... snif hein ?",
                                          "Pas de bol ca", JOptionPane.ERROR_MESSAGE);
		    System.exit(1);
                }
                // La sauvegarde a vraiment marche, Youpi, on va vite informer l'utilisateur
                JOptionPane.
                    showMessageDialog(null, "Youpi, vous etes vraiment inscrit maintenant !\n\n"+
                                      "Pour vos p@ths...euh potes, vous etes matricule         '"+
                                      client.getUser().getUserID()+"',\n et si vous voulez qu'ils vous "+
                                      "contactent en passant par le service P@thFinder(tm),\n "+
                                      "communiquer leur donc ce matricule...",
                                      "Inscription: C'est dans la poche", JOptionPane.INFORMATION_MESSAGE);
            }
        }
        /* Bon maintenant on a un client inscrit si besoin et qui tourne. 
           Mais il va peut-etre falloir dire au registre qu'on est la */
        try {
            client.rebind();
        }catch(PFConnectException rebindImpossible) {
            JOptionPane.
                showMessageDialog(null, "Desole le registre de ce programme n'a pu etre trouve.\n"+
                                  "Veuillez verifier que le programme 'rmiregistry' est charge et relancez\n"+
                                  " le presente application.",
                                  "Il manquait plus que ca", JOptionPane.ERROR_MESSAGE);
            System.exit(1);
        }

        /* ****** */
        /* C'est bon, alors TOUT est OK, donc le client tourne, occupons nous de l'interfacer... */
        /* ****** */

        // Creer un TableauModel bas sur les donnes du client.
        String[] titres = {"Presence", "Nom", "Prenom", "ID"};
        tableauModel=new TableauModel(client.getContactList(), titres, null);
        // Specifier que le TableauModel est observer des donnes du client
        client.getContactList().addObserver(tableauModel);
        // On cre un Tableau bas sur notre TableauModel
        tableau = new Tableau(tableauModel);
        // On spcifie l'couteur de notre TableauModel
        tableauModel.addTableModelListener(tableau);
        // On cre l'interface utilisateur de cet onglet
        this.ui = new OngletPrincipalUI(tableau);
        // On rajoute les couteurs pour les boutons de rajout/suppression
        ui.setEcouteurAjouterPoteButton(new EcouteurAjouterPote());
        ui.setEcouteurSupprimerPoteButton(new EcouteurSupprimerPote());        

        // On dit que le bouton online/offline est observer de l'etat de connexion
        OnlineStateButton osb = new OnlineStateButton();
        client.getConnectionManager().addObserver(osb);
        //PENDING: n'a pas l'air de marcher...

        // On rajoute l'indicateur online/offline
	ui.addPlugInButton(osb.getButton());
        
        // On rajoute le bouton quitter
	ui.addPlugInButton(new QuitButton().getButton());

        pere.getFrame().setTitle(pere.getFrame().getTitle()+" Your ID = "+client.getUser().getUserID());
    }
    
    
    public String getName(){
        return "Tableau de Bord";
    }
 
    public Icon getIcon(){
        return new ImageIcon("mail.gif");
    }

    public JComponent getUI(){
        return this.ui;
    }

    public String getToolTipText(){
        return "Onglet de Controle de P@thFinder";
    }

    public Client getClient(){
	return this.client;
    }

    public Tableau getTableau(){
	return this.tableau;
    }

    public String getSelectedPote(){
        UserData ligneSelectionnee = this.tableau.getSelectedLine();
        if (ligneSelectionnee != null) {
	    try {
		return this.client.lookFor(ligneSelectionnee.getID());
	    }catch(PFException e) {}
	}
        return null;
    }





    //------------------ ECOUTEURS DES BOUTONS AJOUTER/SUPPRIMER DE L'UI -----------------------

    private class EcouteurAjouterPote implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    AjouterPoteDialog ajouterPote = new AjouterPoteDialog();
	    if ( (ajouterPote.getNomFinal() != "") &&
		 (ajouterPote.getPrenomFinal() != "") &&
		 (ajouterPote.getNumeroFinal() != new Integer(0)) ) {
		try {
		    getClient().addToContactList(ajouterPote.getLigneFinal());
		}catch(PFException ex){
                    ex.printStackTrace();
                }
	    }
  	}
    }


    private class EcouteurSupprimerPote implements ActionListener {
	public void actionPerformed(ActionEvent e) {
            UserData ligneSelectionnee = getTableau().getSelectedLine();

            if (ligneSelectionnee != null) {
                String string1 = "Oui je le supprime.";
                Object[] options = {string1, "Non je le laisse!"};

		int n = JOptionPane.
                    showOptionDialog(new JFrame(),
                                     "Supprime "+ligneSelectionnee.getPrenom()+" "
                                     +ligneSelectionnee.getNom()+" de ma liste ?",
                                     "Arrete de dormir...",
                                     JOptionPane.YES_NO_OPTION,
                                     JOptionPane.QUESTION_MESSAGE,
                                     null,     //don't use a custom Icon
                                     options,  //the titles of buttons
                                     string1); //the title of the default button
		if (n == JOptionPane.YES_OPTION) {
		    try {
			getClient().removeFromContactList(ligneSelectionnee);
		    }catch(PFException ex) {
                        ex.printStackTrace();
                    }
		}   
	    }
	}
    }





    //----------------- FONCTIONNALITES DEJA INCLUSES PAR DEFAUT---------------------------------------

    private class QuitButton {
        private JButton b = null;

	public QuitButton() {
            b = new JButton(new ImageIcon("PothFinderClient/gui/Images/Icn-Quit.jpg"));
            b.addActionListener(new EcouteurQuitter());// action a effectuer quand bouton appuye
	}

	public JButton getButton(){
	    return b;
	}

        private class EcouteurQuitter implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                client.quit();
                System.exit(0);
            }
        }
	
    }


    private class OnlineStateButton implements Observer {
        private JButton b = null;
        private Icon offline = new ImageIcon("PothFinderClient/gui/Images/offline.gif");
        private Icon online = new ImageIcon("PothFinderClient/gui/Images/online.gif");

        public OnlineStateButton() {            
            b = new JButton(offline);
            b.setPressedIcon(online);
        }

        public JButton getButton() {
            return b;
        }

        public void update(Observable o, Object arg) {
System.out.println("Notification ! ("+arg+")");            
            if (((Boolean)arg).booleanValue())
                b.setIcon(online);
            else 
                b.setIcon(offline);
        }
    }

}
