package PothFinderClient.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import PothFinderCommon.*;

public class InscriptionUI 
    extends JDialog 
    implements ActionListener, MouseListener {

    private JTextField coordnomX1,coordprenomX1,coordmail1,coordmail2;  // les 4 fenetre text
    private JButton valider,annuler,effacer;                            // les 3 boutons

    private String nom_final="";
    private String prenom_final="";
    private String mail_final="";


    public InscriptionUI() {
        super(new JFrame(), "Inscription a P@thFinder", true);

	JPanel coordonnees = new JPanel ();   // le Panel des coordonnees
	JPanel mail = new JPanel ();          // le Panel du mail : 2 textes et @
	JPanel bouton = new JPanel ();        // la ligne pour les BOUTONS
	JLabel at;                            // l'at (arobace)
	JLabel nomX0,prenomX0,mailX0;         // les 3 Labels
	GridBagConstraints gbc = new GridBagConstraints();


	// prends le Look & Feel de la machine donnee :
	// javax.swing.plaf.metal.MetalLookAndFeel // par defaut
	// javax.swing.plaf.multi.MultiLookAndFeel
	// javax.swing.plaf.basic.BasicLookAndFeel
	try {
  	    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
  	} catch (Exception e) {
  	    System.err.println("Couldn't use the cross-platform "
  			       + "look and feel: " + e);
	}

	setBounds(100,100,400,400);           // Emplacement par rapport au coin haut-gauche
	setResizable(false);                  // impossible de retailler la fenetre

	mail.setLayout(new GridBagLayout());  // on gere les 3 cases du mail 2 textes et @

	coordmail1 = new JTextField(10);      // 1ere fenetre text taille 15
	gbc = new GridBagConstraints();       // gbc recupere les donnees de la fenetre
	gbc.gridx = 0;                        // colonne 0
	gbc.gridy = 0;                        // ligne 0
	gbc.weightx = 10;                     // poids sur de la fenetre dans la ligne 10
  	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	mail.add(coordmail1,gbc);             // on ajoute au Panel mail
	
	at = new JLabel("@");                 // on place un label @
	at.setForeground(Color.black);        // on met @ en noir
	gbc.gridx = 1;                        // colonne 1
	gbc.gridy = 0;                        // ligne 0
	gbc.weightx = 1;                      // poids sur de la fenetre dans la ligne 1
	gbc.insets = new Insets(0,3,0,3);     // 3 espaces a gauche et 3 a droite
  	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	mail.add(at,gbc);                     // on ajoute au Panel mail

	coordmail2 = new JTextField(20);      // on place la 2eme fenetre de texte correspondant
	gbc.gridx = 2;                        // colonne 2
	gbc.gridy = 0;                        // ligne 0
	gbc.weightx = 20;                     // poids sur de la fenetre dans la ligne 20
	gbc.insets = new Insets(0,0,0,0);     // tous les espaces au tour de la fenetre 0
  	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	mail.add(coordmail2,gbc);                // on ajoute au Panel mail

	coordonnees.setLayout(new GridBagLayout());  // le Panel recupere les info nom prenom et mail

	nomX0 = new JLabel("Nom :");        // on place le 1er Label correspondant au nom
	nomX0.setHorizontalTextPosition(0);
	gbc.gridx = 0;                      // colonne 0
	gbc.gridy = 0;                      // ligne 0
	gbc.weightx = 1.0;                  // poids sur de la fenetre dans la ligne 1
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,0,10);  // espaces a droite de la fenetre 10 
  	gbc.fill = GridBagConstraints.NONE; // etendre au max a l'horizontal
	coordonnees.add(nomX0,gbc);         // on ajoute au Panel coordonnees

	prenomX0 = new JLabel("Prenom :");  // on place le 2eme Label correspondant au prenom
	prenomX0.setHorizontalTextPosition(0);
	gbc.gridx = 0;                      // colonne 0
	gbc.gridy = 1;                      // ligne 1
	gbc.weightx = 1.0;                  // poids sur de la fenetre dans la ligne 1
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,0,10);  // espaces a droite de la fenetre 10 
	coordonnees.add(prenomX0,gbc);      // on ajoute au Panel coordonnees

	mailX0 = new JLabel("E-mail :");      // on place le 3eme Label correspondant au mail
	mailX0.setHorizontalTextPosition(0);
	gbc.gridx = 0;                      // colonne 0
	gbc.gridy = 2;                      // ligne 2
	gbc.weightx = 1.0;                  // poids sur de la fenetre dans la ligne 1
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,20,10); // espaces a droite de la fenetre 10 en bas 20
	coordonnees.add(mailX0,gbc);        // on ajoute au Panel coordonnees

	coordnomX1 = new JTextField();      // on place la 1ere fenetre texte correspondant au nom
	gbc.gridx = 1;                      // colonne 1
	gbc.gridy = 0;                      // ligne 0
	gbc.weightx = 100.0;                // poids sur de la fenetre dans la ligne 100
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,0,0);   // tous les espaces au tour de la fenetre 0
	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	coordonnees.add(coordnomX1, gbc);         // on ajoute au Panel coordonnees

	coordprenomX1 = new JTextField();   // on place la 2eme fenetre texte correspondant au prenom
	gbc.gridx = 1;                      // colonne 1
	gbc.gridy = 1;                      // ligne 1
	gbc.weightx = 100.0;                // poids sur de la fenetre dans la ligne 100
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	coordonnees.add(coordprenomX1,gbc);       // on ajoute au Panel coordonnees

  	gbc = new GridBagConstraints();     // on place la fenetre du mail
  	gbc.gridx = 1;                      // colonne 1
  	gbc.gridy = 2;                      // ligne 2
  	gbc.weightx = 50.0;                 // poids sur de la fenetre dans la ligne 50
 	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,20,0);  // les espaces en bas 20
  	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
  	coordonnees.add(mail,gbc);          // on ajoute au Panel coordonnees

  	// BULLES SUR TEXT
  	nomX0.setToolTipText("Donner votre Nom");
  	prenomX0.setToolTipText("Donner votre Prenom");
  	mailX0.setToolTipText("Donner votre adresse E-mail");
  	coordnomX1.setToolTipText("Donner votre Nom");
  	coordprenomX1.setToolTipText("Donner votre Prenom");
  	coordmail1.setToolTipText("Donner votre adresse E-mail");
  	coordmail2.setToolTipText("Donner votre adresse E-mail");

  	// EVENEMENTS
  	coordnomX1.addActionListener(this);    // on veut valider quand ENTREE est tape
  	coordprenomX1.addActionListener(this); // on veut valider quand ENTREE est tape
  	coordmail1.addActionListener(this);  // on veut valider quand ENTREE est tape
  	coordmail2.addActionListener(this);  // on veut valider quand ENTREE est tape

	bouton.setLayout(new FlowLayout(FlowLayout.CENTER,35,0)); // on garde un espace de 35pix entre les elements
	bouton.add(valider = new JButton("VALIDER"));             // un bouton nomme VALIDER 
	bouton.add(annuler = new JButton("ANNULER"));             // un bouton nomme ANNULER
	bouton.add(effacer = new JButton("EFFACER"));             // un bouton nomme EFFACER

	// BULLES SUR BOUTONS
	valider.setToolTipText("Valider l'inscription quand TOUS les champs sont remplis");
	annuler.setToolTipText("Annuler l'inscription");
	effacer.setToolTipText("Effacer tous les champs");

	// EVENEMENTS
	valider.addActionListener(this);               // si on clic sur le bouton
	annuler.addActionListener(this);               // si on clic sur le bouton
	effacer.addActionListener(this);               // si on clic sur le bouton
	//valider.addActionListener(new passageSurBoutonClavier(valider)); // si on passe sur le bouton au clavier
	//annuler.addActionListener(new passageSurBoutonClavier(annuler)); // si on passe sur le bouton au clavier
	//effacer.addActionListener(new passageSurBoutonClavier(effacer)); // si on passe sur le bouton au clavier
       	valider.addMouseListener(this);        // si on passe sur le bouton a la souris
       	annuler.addMouseListener(this);        // si on passe sur le bouton a la souris
       	effacer.addMouseListener(this);        // si on passe sur le bouton a la souris
	
	getContentPane().setLayout(new BorderLayout());  // On positionne les elements 4 lignes et 1 colonne
	getContentPane().add(coordonnees,"North");       // on place la ligne du NOM
	getContentPane().add(bouton,"South");            // on place la ligne des BOUTONS

	pack();
	setVisible(true);
    }


    //si on clic sur un bouton

    // si tous les champs sont remplis on valide les donnees
    // sinon message d'erreur
    public void actionPerformed(ActionEvent e) {
	String bouton = e.getActionCommand();
        
	if (bouton.equals("ANNULER")) {   // on quitte la fenetre 
            System.exit(1);
        } else if (bouton.equals("EFFACER")) {   // on efface les champs
	    coordnomX1.setText("");
	    coordprenomX1.setText("");
	    coordmail1.setText("");
	    coordmail2.setText("");
	} else if (champsRemplis())  {                          // on valide la fenetre
            nom_final = coordnomX1.getText();
            prenom_final = coordprenomX1.getText();
            mail_final = coordmail1.getText()+"@"+coordmail2.getText();
            dispose();
        } else {
            JOptionPane.showMessageDialog(null, "TOUS les champs doivent etre remplis!",
                                          "message d'erreur", JOptionPane.ERROR_MESSAGE);
        }
    }



    //**************************************************************************************************************

    public boolean champsRemplis(){
	return !( (coordnomX1.getText().equals(""))    ||
                     (coordprenomX1.getText().equals("")) ||
                     (coordmail1.getText().equals(""))  ||
                     (coordmail2.getText().equals("")) );
    }

    public String getNomFinal(){
	return nom_final;
    }
    
    public String getPrenomFinal(){
	return prenom_final;
    }
    
    public String getMailFinal(){
	return mail_final;
    }

    public boolean existResult() {
        return !(getNomFinal().equals("") ||
                 getPrenomFinal().equals("") ||
                 getMailFinal().equals(""));
    }


    public UserProperties getResult() {
        if (existResult()) {
            return new UserProperties(getNomFinal(), getPrenomFinal(), getMailFinal());
        } else 
            return null;
    }
                               

 
    //**************************************************************************************************************
    //Si on passe sur un bouton avec la souris

    public void mouseEntered(MouseEvent e) {
        //on arrive sur le bouton le fond devient rouge
        JButton bouton = (JButton)e.getComponent();
        bouton.setBackground(Color.gray);
    }
    
    public void mouseExited(MouseEvent e) {
        //on sort du bouton le fond devient gris clair
        JButton bouton = (JButton)e.getComponent();
        bouton.setBackground(Color.lightGray);
    }

    public void mouseClicked(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    

    
    //**************************************************************************************************************
    //Si on passe sur un bouton avec le clavier
    /*

    class passageSurBoutonClavier implements DropTargetListener {
	JButton button;

	public passageSurBoutonClavier(JButton bouton) {
	    button=bouton;
	}
	public void dragEnter(DropTargetDragEvent e) {
	    //on arrive sur le bouton le fond devient rouge
	    button.setBackground(Color.red);
	}
	public void dragExit(DropTargetEvent e) {
	    //on sort du bouton le fond devient gris clair
	    button.setBackground(Color.blue);
	}
    }
    */
    //**************************************************************************************************************
    //si on clic sur un bouton

//      class ecouteurValider implements ActionListener {
//  	// si tous les champs sont remplis on valide les donnees
//  	// sinon message d'erreur
//  	public void actionPerformed(ActionEvent e) {
//  	    if ( (coordnomX1.getText().equals(""))    ||
//  		 (coordprenomX1.getText().equals("")) ||
//  		 (coordmail1.getText().equals(""))  ||
//  		 (coordmail2.getText().equals("")) ) 
//  		JOptionPane.showMessageDialog(null, "TOUS les champs doivent etre remplis!",
//  					      "message d'erreur",JOptionPane.ERROR_MESSAGE);
//  	    else {
//  		nom_final=coordnomX1.getText();
//  		prenom_final=coordprenomX1.getText();
//  		mail_final=coordmail1.getText()+"@"+coordmail2.getText();
//  		setVisible(false);
//  	    }
//  	}
//      }

//      class ecouteurAnnuler implements ActionListener {
//  	// on quitte la fenetre 
//  	public void actionPerformed(ActionEvent e) {
//  	    setVisible(false);
//  	}
//      }

 
    //**************************************************************************************************************
    //***************************             MAIN               ***************************************************
    //**************************************************************************************************************

      public static void main (String [] argv){
  	InscriptionUI ig =new InscriptionUI();
        System.out.println("Main example : "+ig.getPrenomFinal()+" "+
                           ig.getNomFinal()+" "+ig.getMailFinal());
        System.exit(0);
      }
}
