package PothFinderClient.gui;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import PothFinderClient.*;
import PothFinderClient.gui.table.*;

public class AjouterPoteDialog extends JDialog {
    JTextField coordnomX1,coordprenomX1;//,coordnumeroX1;  // les 3 fenetres text
    JButton valider,annuler,effacer;                    // les 3 boutons
    String nom_final="";
    String prenom_final="";
    Integer numero_final=null;//new Integer(0);
    private WholeNumberField coordnumeroX1;

    public AjouterPoteDialog () {
	this(new JFrame());
    }

    public AjouterPoteDialog (Frame parent) {
	this(parent,true);
    }

    public AjouterPoteDialog (Frame parent,boolean alors) {
	super(parent,alors);

	JPanel coordonnees = new JPanel ();   // le Panel des coordonnees
	JPanel bouton = new JPanel ();        // la ligne pour les BOUTONS
	JLabel nomX0,prenomX0,numeroX0;       // les 3 Labels
	GridBagConstraints gbc = new GridBagConstraints();

	// prends le Look & Feel de la machine donnee :
	// javax.swing.plaf.metal.MetalLookAndFeel // par defaut
	// javax.swing.plaf.multi.MultiLookAndFeel
	// javax.swing.plaf.basic.BasicLookAndFeel
	try {
  	    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
  	} catch (Exception e) {
  	    System.err.println("Couldn't use the cross-platform "
  			       + "look and feel: " + e);
	}

	setTitle("Ajouter une connaissance"); // Titre de la fenetre
	setBounds(100,100,400,400);           // Emplacement par rapport au coin haut-gauche
	setResizable(false);                  // impossible de retailler la fenetre

	coordonnees.setLayout(new GridBagLayout());  // le Panel recupere les info nom prenom et numero

	nomX0 = new JLabel("Nom :");        // on place le 1er Label correspondant au nom
	nomX0.setHorizontalTextPosition(0);
	gbc.gridx = 0;                      // colonne 0
	gbc.gridy = 0;                      // ligne 0
	gbc.weightx = 1.0;                  // poids sur de la fenetre dans la ligne 1
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,0,10);  // espaces a droite de la fenetre 10 
  	gbc.fill = GridBagConstraints.NONE; // etendre au max a l'horizontal
	coordonnees.add(nomX0,gbc);         // on ajoute au Panel coordonnees

	prenomX0 = new JLabel("Prenom :");  // on place le 2eme Label correspondant au prenom
	prenomX0.setHorizontalTextPosition(0);
	gbc.gridx = 0;                      // colonne 0
	gbc.gridy = 1;                      // ligne 1
	gbc.weightx = 1.0;                  // poids sur de la fenetre dans la ligne 1
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,0,10);  // espaces a droite de la fenetre 10 
	coordonnees.add(prenomX0,gbc);      // on ajoute au Panel coordonnees

	numeroX0 = new JLabel("Numero :");      // on place le 3eme Label correspondant au mail
	numeroX0.setHorizontalTextPosition(0);
	gbc.gridx = 0;                      // colonne 0
	gbc.gridy = 2;                      // ligne 2
	gbc.weightx = 1.0;                  // poids sur de la fenetre dans la ligne 1
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,20,10); // espaces a droite de la fenetre 10 en bas 20
	coordonnees.add(numeroX0,gbc);        // on ajoute au Panel coordonnees

	coordnomX1 = new JTextField();      // on place la 1ere fenetre texte correspondant au nom
	gbc.gridx = 1;                      // colonne 1
	gbc.gridy = 0;                      // ligne 0
	gbc.weightx = 100.0;                // poids sur de la fenetre dans la ligne 100
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,0,0);   // tous les espaces au tour de la fenetre 0
	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	coordonnees.add(coordnomX1, gbc);         // on ajoute au Panel coordonnees

	coordprenomX1 = new JTextField();   // on place la 2eme fenetre texte correspondant au prenom
	gbc.gridx = 1;                      // colonne 1
	gbc.gridy = 1;                      // ligne 1
	gbc.weightx = 100.0;                // poids sur de la fenetre dans la ligne 100
	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
	coordonnees.add(coordprenomX1,gbc);       // on ajoute au Panel coordonnees

	coordnumeroX1  = new WholeNumberField(0, 10);// on place la fenetre du numero
  	gbc.gridx = 1;                      // colonne 1
  	gbc.gridy = 2;                      // ligne 2
  	gbc.weightx = 100.0;                // poids sur de la fenetre dans la ligne 100
 	gbc.weighty = 1.0;                  // poids sur de la fenetre dans la colonne 1
	gbc.insets = new Insets(0,0,20,0);  // les espaces en bas 20
  	gbc.fill = GridBagConstraints.HORIZONTAL; // etendre au max a l'horizontal
  	coordonnees.add(coordnumeroX1,gbc);       // on ajoute au Panel coordonnees

  	// BULLES SUR TEXT
  	nomX0.setToolTipText("Donner le Nom de la Connaissance");
  	prenomX0.setToolTipText("Donner le Prenom de la Connaissance");
  	numeroX0.setToolTipText("Donner le Numero de la Connaissance");
  	coordnomX1.setToolTipText("Donner votre Nom de la Connaissance");
  	coordprenomX1.setToolTipText("Donner votre Prenom de la Connaissance");
  	coordnumeroX1.setToolTipText("Donner le Numero de la Connaissance");

  	// EVENEMENTS
  	coordnomX1.addActionListener(new ecouteurValider());    // on veut valider quand ENTREE est tape
  	coordprenomX1.addActionListener(new ecouteurValider()); // on veut valider quand ENTREE est tape
  	coordnumeroX1.addActionListener(new ecouteurValider());  // on veut valider quand ENTREE est tape

	bouton.setLayout(new FlowLayout(FlowLayout.CENTER,35,0)); // on garde un espace de 35pix entre les elements
	bouton.add(valider = new JButton("VALIDER"));             // un bouton nomme VALIDER 
	bouton.add(annuler = new JButton("ANNULER"));             // un bouton nomme ANNULER
	bouton.add(effacer = new JButton("EFFACER"));             // un bouton nomme EFFACER

	// BULLES SUR BOUTONS
	valider.setToolTipText("Valider l'inscription quand TOUS les champs sont remplis");
	annuler.setToolTipText("Annuler l'inscription");
	effacer.setToolTipText("Effacer tous les champs");

	// EVENEMENTS
	valider.addActionListener(new ecouteurValider());               // si on clic sur le bouton
	annuler.addActionListener(new ecouteurAnnuler());               // si on clic sur le bouton
	effacer.addActionListener(new ecouteurEffacer());               // si on clic sur le bouton
	//valider.addActionListener(new passageSurBoutonClavier(valider)); // si on passe sur le bouton au clavier
	//annuler.addActionListener(new passageSurBoutonClavier(annuler)); // si on passe sur le bouton au clavier
	//effacer.addActionListener(new passageSurBoutonClavier(effacer)); // si on passe sur le bouton au clavier
       	valider.addMouseListener(new passageSurBouton(valider));        // si on passe sur le bouton a la souris
       	annuler.addMouseListener(new passageSurBouton(annuler));        // si on passe sur le bouton a la souris
       	effacer.addMouseListener(new passageSurBouton(effacer));        // si on passe sur le bouton a la souris
	
	getContentPane().setLayout(new BorderLayout());  // On positionne les elements 4 lignes et 1 colonne
	getContentPane().add(coordonnees,"North");       // on place la ligne du NOM
	getContentPane().add(bouton,"South");            // on place la ligne des BOUTONS

	pack();
	setVisible(true); 
    }

    //**************************************************************************************************************
    
    public String getNomFinal(){
	return nom_final;
    }
    
    public String getPrenomFinal(){
	return prenom_final;
    }
    
    public Integer getNumeroFinal(){
	return numero_final;
    }
    
    public UserData getLigneFinal(){
	return new UserData(getNomFinal(),getPrenomFinal(),getNumeroFinal());
    }
    
    //**************************************************************************************************************
    //Si on passe sur un bouton avec la souris
    
    class passageSurBouton extends MouseAdapter {
	JButton button;
	
	public passageSurBouton(JButton bouton) {
	    button=bouton;
	}
	public void mouseEntered(MouseEvent e) {
	    //on arrive sur le bouton le fond devient rouge
	    button.setBackground(Color.red);
	}
	public void mouseExited(MouseEvent e) {
	    //on sort du bouton le fond devient gris clair
	    button.setBackground(Color.lightGray);
	}
    }
    
    //**************************************************************************************************************
    //Si on passe sur un bouton avec le clavier
    /*
      
      class passageSurBoutonClavier implements DropTargetListener {
      JButton button;
      
      public passageSurBoutonClavier(JButton bouton) {
      button=bouton;
      }
      public void dragEnter(DropTargetDragEvent e) {
      //on arrive sur le bouton le fond devient rouge
	    button.setBackground(Color.red);
	}
	public void dragExit(DropTargetEvent e) {
	    //on sort du bouton le fond devient gris clair
	    button.setBackground(Color.blue);
	}
    }
    */
    //**************************************************************************************************************
    //si on clic sur un bouton

    class ecouteurValider implements ActionListener {
	// si tous les champs sont remplis on valide les donnees
	// sinon message d'erreur

	public void actionPerformed(ActionEvent e) {
	    if ( (coordnomX1.getText().equals(""))    ||
		 (coordprenomX1.getText().equals("")) ||
		 (coordnumeroX1.getText().equals("")) ) 
		JOptionPane.showMessageDialog(null, "TOUS les champs doivent etre remplis!",
					      "message d'erreur",JOptionPane.ERROR_MESSAGE);
	    else {
		try {
		    nom_final=coordnomX1.getText();
		    prenom_final=coordprenomX1.getText();
		    numero_final=new Integer(coordnumeroX1.getText());
		    setVisible(false);
		} catch (Exception ex) {
		    coordnumeroX1.setText("");
		}



		    //JOptionPane.showMessageDialog(null, "le champ numero ne peut recevoir qu'un numero!",
		    //				  "message d'erreur",JOptionPane.WARNING_MESSAGE);
		//
		//}
	    }
	}
    }

    class ecouteurAnnuler implements ActionListener {
	// on quitte la fenetre 
	public void actionPerformed(ActionEvent e) {
		setVisible(false);
	}
    }
    
    class ecouteurEffacer implements ActionListener {
	// on remet tous les textes blancs
	public void actionPerformed(ActionEvent e) {
	    coordnomX1.setText("");
	    coordprenomX1.setText("");
	    coordnumeroX1.setText("");
	}
    }
 
    //**************************************************************************************************************
    //***************************             MAIN               ***************************************************
    //**************************************************************************************************************

    public static void main (String [] argv){
	AjouterPoteDialog ig =new AjouterPoteDialog();
	ig.pack();
	ig.setVisible(true);
    }
}







