package PothFinderClient;

import java.util.*;
import PothFinderClient.comparators.*;


public class UserData extends Vector {
    /** prends en parametre les elements d'une ligne du tableau TableauModel et
	les transforme en un Vecteur ligne
    */

    public static final int PRESENCE_COL = 0;
    public static final int NOM_COL      = 1;
    public static final int PRENOM_COL   = 2;
    public static final int ID_COL       = 3;


    /** renvoi avec un nom vide */
    public UserData (){
	this("");
    }

    /** renvoi avec un prenom vide */
    public UserData (String nom){
	this(nom,"");
    }

    /** renvoi avec un numero vide */
    public UserData (String nom,String prenom){
	this(nom,prenom,new Integer(0));
    }

    /** renvoi avec un present faux */
    public UserData (String nom,String prenom,Integer numero){
	this(nom,prenom,numero, Boolean.FALSE);
    }


    /** recupere toutes les donnees */
    public UserData (String nom,String prenom,Integer numero,Boolean present){
	super(4);
	this.add(present);
	this.add(nom);
	this.add(prenom);
	this.add(numero);
    }


    public static Comparator Comparator(int column, boolean ascending) {
        switch(column) {
        case PRESENCE_COL:
            if (ascending) return new PresenceComparatorDesc();
            else return new PresenceComparatorAsc();
        case NOM_COL: 
            if (ascending) return new NomComparatorAsc();
            else return new NomComparatorDesc();
        case PRENOM_COL:
            if (ascending) return new PrenomComparatorAsc();
            else return new PrenomComparatorDesc();
        case ID_COL: 
            if (ascending) return new NumeroComparatorAsc();
            else return new NumeroComparatorDesc();
        default: throw new ArrayIndexOutOfBoundsException("Pas de comparateur pour la colonne "+column+".");
        }
    }



    /** renvoi le nom */
    public String getNom(){
	return (String)this.get(NOM_COL);
    }

    /**  renvoi le ID  */
    public Integer getID(){
	return (Integer)this.get(ID_COL);
    }

    /** renvoi le prenom  */
    public String getPrenom(){
	return (String)this.get(PRENOM_COL);
    }

    /** renvoi la presence */
    public Boolean getPresence() {
	return (Boolean)this.get(PRESENCE_COL);
    }

    /** change le nom  */
    public void setNom(String nom){
	this.set(NOM_COL,nom);
    }

    /** 
	change le ID 
    */
    public void setID(Integer numero){
	this.set(ID_COL,numero);
    }

    /**
       change le prenom
    */
    public void setPrenom(String prenom){
	this.set(PRENOM_COL,prenom);
    }

    /**
       change la presence
    */
    public void setPresence(Boolean presence){
	this.set(PRESENCE_COL, presence);
    }


    public static void main(String [] argv){
	UserData l1=new UserData();
	UserData l2=new UserData("toto");
	UserData l3=new UserData("titi","durand");
	UserData l4=new UserData("toto","tata",new Integer(1001));

	System.out.println("nom "+ l3.getNom() +" prenom "+ l3.getPrenom()+" numero "+ l3.getID()+" present "+l3.getPresence());
	System.out.println("nom "+ l4.getNom() +" prenom "+ l4.getPrenom()+" numero "+ l4.getID()+" present "+l4.getPresence());

	l4.setNom("delgatto");
	l3.setPresence(new Boolean(true));
	l4.setPrenom("eric");
	l3.setID(new Integer(002));
	System.out.println("nom "+ l3.getNom() +" prenom "+ l3.getPrenom()+" numero "+ l3.getID()+" present "+l3.getPresence());
	System.out.println("nom "+ l4.getNom() +" prenom "+ l4.getPrenom()+" numero "+ l4.getID()+" present "+l4.getPresence());

	l4.set(1,"fromy");
	System.out.println("nom "+ l4.getNom() +" prenom "+ l4.getPrenom()+" numero "+ l4.getID()+" present "+l4.getPresence());

	l1=l4;

	System.out.println("nom "+ l1.get(1) +" prenom "+ l1.get(2)+" numero "+ l1.get(3)+" present "+l1.get(0));
	System.out.println("nombre col 4: "+ l4.size());
    }
}


