package PothFinderClient;

import java.util.*;
import java.io.*;


public class ContactList 
    extends Observable 
    implements Serializable {


    protected Vector dataVector;


    public ContactList() {
        this.dataVector = new Vector();
    }


    public boolean add(UserData ud) {
        if (! this.dataVector.contains(ud)) {
            boolean result = this.dataVector.add(ud);
            notifyObservers(this.dataVector);
            return result;
        } else 
            return false;
    }


    public boolean remove(UserData ud) {
        boolean result = this.dataVector.remove(ud);
        notifyObservers(this.dataVector);
        return result;
    }



    public void everybodyAbsent() {
        for (int i=0; i < this.dataVector.size(); i++)
            ((UserData)this.dataVector.get(i)).setPresence(Boolean.FALSE);
        notifyObservers(this.dataVector);
    }


    protected synchronized int rechercheID(Integer pote) {
        /* Recherche linaire avec sentinelle */
        //System.out.println("Recherche ID "+pote+" dans "+this.dataVector);
        int dataSize = this.dataVector.size();
        if (dataSize > 0) {
            int lastIndex = dataSize-1;
            //System.out.println("lastIndex == "+lastIndex);
            UserData lastData = (UserData)(this.dataVector.get(lastIndex));
            //System.out.println("lastData == "+lastData);
            Integer savedValue = lastData.getID();
            //System.out.println("savedValue == "+savedValue);
            if (pote.equals(savedValue)) {
                //System.out.println("pote ("+pote+") == saved value ("+savedValue+")");
                   return lastIndex;
            }else {
                lastData.setID(pote);            
                int i;
                for( i=0; !((UserData)this.dataVector.get(i)).getID().equals(pote); i++);
                //System.out.println("i == "+i);
                lastData.setID(savedValue);
                if (i != lastIndex)
                    return i;
            }
        }
        return -1;
    }
            
    public synchronized void hasJoined(Integer pote) {
        int ligne = rechercheID(pote);
        if (ligne != -1) {
            ((UserData)this.dataVector.get(ligne)).setPresence(Boolean.TRUE);
            notifyObservers(this.dataVector);
        }
    }

    public synchronized void hasLeft(Integer pote) {
        int ligne = rechercheID(pote);
        if (ligne != -1) {
            ((UserData)this.dataVector.get(ligne)).setPresence(Boolean.FALSE);
            notifyObservers(this.dataVector);
        }
    }

    /**
       Renvoie (exporte) le tableau sous la forme d'un Hashset 
       reprsentant la liste des contacts.
    */
    public HashSet asHashSetOfID() {
	HashSet result = new HashSet();
	for (int i = 0; i < this.dataVector.size(); i++)
	    result.add(((UserData)this.dataVector.get(i)).getID());
	return result;
    }


    public Vector getDataVector(){
	return dataVector;
    }

    public String toString(){
        return getDataVector().toString();
    }
}
