package PothFinderClient;
/**
 * ConnectionManager.java
 *
 *
 * Created: Mon Jan 18 08:27:03 1999
 *
 * @author 
 * @version
 */
import java.util.*;
import java.io.*;
import java.rmi.*;

import PothFinderCommon.*;


public class ConnectionManager 
    extends Observable 
    implements Runnable, Serializable {
    Client c;
    Thread t = new Thread(this);
    
    public ConnectionManager(Client c) {
        this.c = c;
        disconnected();
    }
    
    public void run() {
        boolean OK = false;
        while (! OK) {
            try {    
                c.findServer();
                c.logIn();
                OK = true;
                // PENDING: voir en dessous
                //System.out.println("Notifying observers (connected)");                
                notifyObservers(new Boolean(true));
                //System.out.println("Done");
                System.out.println("you're online");                
            }catch(Exception pfe) {
                try {
                    t.sleep(1000*Integer.parseInt(c.getConfig().getProperty("RetryTime", "5")));
                }catch(Exception e){ 
                }
            }
        }
    }


    /** Fonction appele par le client lorsqu'il a dtect qu'il n'tait pas 
        connect (RemoteException, PFQueryException) */
    public void disconnected() {
        System.out.println("you're offline");        
        //        System.out.println("Notifying observers("+countObservers()+" (disconnected)");
        // PENDING: ne marche pas, l'icone ne bouge pas d'un poil, on rentre meme pas
        //          la fonction update. pourquoi ? .......
        notifyObservers(new Boolean(false));
        //System.out.println("Done");
        c.getContactList().everybodyAbsent();
        try {
            //            Naming.unbind("P@thFinderClient");
            if (! t.isAlive()) {
                t = new Thread(this);
                t.start();
            }
        }catch(Exception e) {            
            // PENDING: A ETUDIER !!!!
            e.printStackTrace();
        }
    }

} // ConnectionManager
