package PothFinderClient;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;
import java.rmi.server.*;

import japie.util.*;
import PothFinderCommon.*;



public class Client  
    extends UnicastRemoteObject 
    implements Serializable, ServerAvailableMethods {
    
    public static final String DATA_FILENAME   = "PothFinder.data";
    public static final String CONFIG_FILENAME = "PothFinder.conf";

    protected                   User  me;
    protected         UserProperties  myCoordinates;
    protected            ContactList  contactList;
    protected ClientAvailableMethods  distantMethods;
    protected             Properties  config;
    protected      ConnectionManager  connectionManager;

    // -- Main -------------- ----------------- --------------- ---------------- ----------
    public static void main(String[] args) {
        Client c = null;
        try {
            System.out.println("\n\nInitialisation..."); 
            c = Client.load();
            System.out.println("Les donnees ont ete chargees");
        }catch(PFIOException fioe) {
            // On n'a p charger un client srialis, il va donc falloir en crer un.
            UserProperties up = new UserProperties("Toto", "Durand", "toto@aol.com");
            System.out.println("Creation d'un nouvel utilisateur...");
            try {
                c = new Client(up);
            }catch(PFIOException ioe) {
                System.out.println("Desole, le fichier de configuration '"+CONFIG_FILENAME+
                                   "' n'a pu etre charge, inscription impossible");
                System.exit(1);
            }catch(PFQueryException qe) {
                System.out.println("Desole, l'utilisateur "+up+" existe deja sur le serveur !");
                System.exit(2);
            }catch(PFConnectException ce) {
                System.out.println("Desole, la connexion avec le serveur P@thFinder(tm) "+
                                   "n'a pu se faire, inscription impossible");
                ce.printStackTrace();
                System.exit(3);
            }catch(Exception e) {
                e.printStackTrace();
                System.exit(255);
            }
            System.out.println("Creation du nouvel utilisateur OK");
            try {
                c.save();
                System.out.println("Donnees de l'utilisateur sauvegardees.");                
            }catch(PFIOException ioe) {
                System.out.println("Desole, sauvegarde de l'utilisateur impossible");
                ioe.printStackTrace();
                System.exit(4);
            }
            /*        }catch(PFConnectException pfce) {
            System.out.println("Connexion au serveur impossible");
            System.exit(45);
            }*/
        }
        try {
            c.rebind(); // on se met dans le registre.
            System.out.println("Client initialise: "+c.getUser().getUserID());
        }catch(PFConnectException ce) {
            System.out.println("Desole, l'inscription de ce programme dans le registre a echoue.\n"+
                               "Veuillez verifier que le programme 'rmiregistry' est charge et relancez"+
                               " ce programme.");
            System.exit(5);
             /*        }catch(java.net.UnknownHostException uhe) {
                       System.out.println("Desole, il a ete impossible de determiner l'addresse internet de votre "+
                       "ordinateur, verifiez si votre ordinateur est bien configure pour Internet");
                       System.exit(6);*/
        }
        try {
            c.getContactList().add(new UserData("van Leeuwen", "Marc" , new Integer(6)));
            System.out.println(c.isLogged(new Integer(7)));
            System.out.println(c.lookFor(new Integer(12)));
        }catch(PFQueryException pfqe) {
            System.out.println("Vous n'etes pas logge et ne pouvez donc interroger"+
                               "le serveur. Veuillez vous logger d'abord");
        }catch(PFSecurityException pfqe) {
            System.out.println("Vous n'avez pas ete reconnu par le serveur. "+
                               " Peut etre vous faudra-t-il vous reinscrire...");
        }catch(Exception pfce) {
            System.out.println("VRAIE ERREUR: Impossible de se connecter au serveur !");
            pfce.printStackTrace();
        }
    }





    
    // -- Constructor(s) --------------- ---------------- ---------------- ----------------

    /** Ce constructeur est utilis lors du chargement */
    private Client() throws PFIOException, RemoteException {
        try {
            config = NiceProperties.load(CONFIG_FILENAME);
        }catch(IOException e) {
            throw new PFIOException("Loading of config file '"+CONFIG_FILENAME+" failed.", e);
        }
    }


    /** Ce Constructeur n'est en fait utilis que si aucun Client n'a pu tre dsrialis */
    public Client(UserProperties myCoordinates) 
        throws PFIOException, PFConnectException, PFQueryException, RemoteException {
        this();
        findServer();
        try {
            this.me = distantMethods.createUser(myCoordinates);            
        }catch(RemoteException e) {
            throw new PFConnectException(e);
        }
        this.myCoordinates = myCoordinates;
        this.contactList = new ContactList();
        try {
            this.me.setCurrentAddress(InetAddress.getLocalHost());
        }catch(Exception e) {
            throw new PFConnectException(e);
        }
        this.connectionManager = new ConnectionManager(this);
    }
    



    // -- Accessors/Setters Stuff ------ ---------------- ---------------- ----------------

    public User getUser() {
        return me;
    }

    public UserProperties getUserCoordinates() {
        return myCoordinates;
    }

    public ContactList getContactList() {
        return contactList;
    }

    public Properties getConfig() {
        return config;
    }

    public ConnectionManager getConnectionManager() {
        return connectionManager;
    }

    public void setUser(User me) {
        this.me = me;
    }
    
    public void setContactList(ContactList cl) {
        this.contactList = cl;
    }
    
    public void setUserCoordinates(UserProperties up) {
        this.myCoordinates = up;
    }
    
    
    
    public void setConnectionManager(ConnectionManager newConnectionManager) {
        this.connectionManager = newConnectionManager;
    }



    // -- Registry Binding Stuff -------- ---------------- ---------------- ----------------
    
    public void findServer() throws PFConnectException {
        try {
            distantMethods = (ClientAvailableMethods)
                Naming.lookup("//"+config.getProperty("ServerLocation")+"/P@thFinderServer");
        }catch(Exception e) {
            distantMethods=null; // pour tre sr.
            throw new PFConnectException(e);
        }
    }

    public void rebind() throws PFConnectException {
        try {
            Naming.rebind("P@thFinderClient", this);
        }catch(Exception e) {
            throw new PFConnectException(e);
        }
    }




    // -- Distant Stuff ---------------- ---------------- ---------------- ---------------- */

    public void logIn() throws PFConnectException, PFSecurityException {
        HashSet connectedNowSet = null;
        Object[] connectedNow = null;
        try{
            connectedNowSet = distantMethods.logIn(me, getContactList().asHashSetOfID());
            connectedNow = (connectedNowSet.toArray());
            for(int i=0; i < connectedNow.length; i++) {
                this.hasJoined((Integer)connectedNow[i]);
            }
        }catch(PFSecurityException pfse) {
            throw pfse;
        }catch (Exception ex) {            
            getConnectionManager().disconnected();            
        }        
    }

    
    public void logOff() throws PFConnectException, PFSecurityException {
        try{
            distantMethods.logOff(me);
        }catch(PFSecurityException pfse) {
            throw pfse;
        }catch (Exception ex) {
            getConnectionManager().disconnected();
        }
        
        try {
            Naming.unbind("P@thFinderClient");
        }catch(Exception e) {
            e.printStackTrace();
        }
    }
    

    public boolean isLogged(Integer poteID) 
        throws PFConnectException, PFQueryException, PFSecurityException {
        try{
            boolean result = distantMethods.isLogged(me, poteID);
            return result;
        }catch(PFSecurityException pfse) {
            throw pfse;
        }catch (Exception ex) {
            getConnectionManager().disconnected();
        }
        return false;
    }

    
    public String lookFor(Integer poteID) 
        throws PFConnectException, PFQueryException, PFSecurityException {
        try{
            return distantMethods.lookFor(me, poteID);
        }catch(PFSecurityException pfse) {
            throw pfse;
        }catch (Exception ex) {
            getConnectionManager().disconnected();
        }
        return null;
    }
    





    // -- ContactList Stuff --------------- ---------------- ---------------- ---------------- */

    public void addToContactList(UserData userData) 
        throws PFConnectException, PFQueryException, PFSecurityException {
        try {
            getContactList().add(userData);
            if (distantMethods.addToContactList(me, userData.getID()))                
                hasJoined(userData.getID());
        }catch(PFSecurityException pfse) {
            throw pfse;
        }catch (Exception ex) {
            getConnectionManager().disconnected();
        }
    }

    public void removeFromContactList(UserData userData) 
        throws PFConnectException, PFQueryException, PFSecurityException {
        try {
            getContactList().remove(userData);
            distantMethods.addToContactList(me, userData.getID());
        }catch(PFSecurityException pfse) {
            throw pfse;
        }catch (Exception ex) {
            getConnectionManager().disconnected();
        }
    }




    
    // -- Load/Save Stuff ---------------- ---------------- ---------------- ---------------- */

    public static Client load() throws PFIOException {
        ObjectInputStream p = null;
        try {
	  Client result = new Client();

            p = new ObjectInputStream(new FileInputStream(DATA_FILENAME+".User"));
            result.setUser((User)p.readObject());
            p.close();

            p = new ObjectInputStream(new FileInputStream(DATA_FILENAME+".Coordinates"));
            result.setUserCoordinates((UserProperties)p.readObject());
            p.close();

            p = new ObjectInputStream(new FileInputStream(DATA_FILENAME+".CL"));
            result.setContactList((ContactList)p.readObject());
            p.close();


            result.getContactList().everybodyAbsent();
            result.getUser().setCurrentAddress(InetAddress.getLocalHost());
            result.setConnectionManager(new ConnectionManager(result));
            return result;
        }catch(Exception e) {
            try {
                p.close();
            }catch(Exception e2) {
            }finally{
                throw new PFIOException(e);
            }
        }
    }


    public void save() throws PFIOException {
        ObjectOutputStream p = null;
        try {
            p = new ObjectOutputStream(new FileOutputStream(DATA_FILENAME+".User"));
            p.writeObject(this.getUser());
            p.flush();
            p.close();

            p = new ObjectOutputStream(new FileOutputStream(DATA_FILENAME+".Coordinates"));
            p.writeObject(this.getUserCoordinates());
            p.flush();
            p.close();

            p = new ObjectOutputStream(new FileOutputStream(DATA_FILENAME+".CL"));
            p.writeObject(this.getContactList());
            p.flush();
            p.close();
        }catch(Exception e) {
            try {
                e.printStackTrace();
                p.close();
            }catch(Exception e2) {
            }finally{
                throw new PFIOException(e);
            }
        }
    }



    // -- ServerAvailableMethods Implementation ---- ---------------- ------------------- */
    public User whoAmI(){
        return getUser();
    }

    public void hasJoined(Integer pote){
        getContactList().hasJoined(pote);
    }

    public void hasLeft(Integer pote){
        getContactList().hasLeft(pote);
    }




    // -- Miscellanous ------------ ---------------- ---------------- ------------------- */

    protected void finalize() throws Throwable {
        try {
            save();
            logOff();
        }catch(Exception e){}
        super.finalize();
    }

    public void quit() {
        try {
            finalize();
        }catch(Throwable e){}
    }
}
