/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlAsciiInputStream;
import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlQueryData;
import com.imaginary.sql.msql.MsqlResultSet;
import com.imaginary.sql.msql.MsqlResultSetMetaData;
import com.imaginary.sql.msql.MsqlUnicodeInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class MsqlTableList
extends MsqlResultSet {
    private boolean complete = false;
    private MsqlConnection connection = null;
    private int rowNumber = -1;
    private byte[][] currentRow = null;
    private MsqlResultSet fieldInfo = null;
    protected byte[] lastColumn = null;
    private ResultSetMetaData metaData = null;
    private String namePattern = null;
    private MsqlException readException = null;
    private ArrayList rows = new ArrayList();

    MsqlTableList(MsqlConnection msqlConnection, String string) throws SQLException {
        super(null);
        this.connection = msqlConnection;
        this.namePattern = string;
        this.getRows();
    }

    public boolean absolute(int n) throws SQLException {
        throw new MsqlException("This result set is TYPE_FORWARD_ONLY.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.complete) {
                    if (this.fieldInfo == null) return;
                    this.fieldInfo.close();
                    return;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void complete() {
        this.connection.release();
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            this.complete = true;
        }
    }

    public int findColumn(String string) throws SQLException {
        if (string.equals("TABLE_CAT")) {
            return 1;
        }
        if (string.equals("TABLE_SCHEM")) {
            return 2;
        }
        if (string.equals("TABLE_NAME")) {
            return 3;
        }
        if (string.equals("TABLE_TYPE")) {
            return 4;
        }
        if (string.equals("REMARKS")) {
            return 5;
        }
        throw new SQLException("Invalid column name: " + string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlAsciiInputStream(this.lastColumn);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.getColumn(n);
        return new ByteArrayInputStream(this.lastColumn);
    }

    public boolean getBoolean(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return false;
        }
        if (this.lastColumn.length == 0) {
            return false;
        }
        return this.lastColumn[0] != 48 && this.lastColumn[0] != 0;
    }

    public byte getByte(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return 0;
        }
        return this.lastColumn[0];
    }

    public byte[] getBytes(int n) throws SQLException {
        this.getColumn(n);
        return this.lastColumn;
    }

    protected void getColumn(int n) throws SQLException {
        try {
            this.lastColumn = this.currentRow[n - 1];
        }
        catch (Exception exception) {
            if (this.currentRow == null) {
                throw new MsqlException("-1:Result set positioned before first row.");
            }
            throw new MsqlException(exception);
        }
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.metaData != null) {
            return this.metaData;
        }
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.fieldInfo != null) {
                    this.metaData = new MsqlResultSetMetaData(this.fieldInfo);
                    return this.metaData;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getRow() throws SQLException {
        return this.rowNumber + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[][] getRow(int n) throws SQLException {
        if (this.readException != null) {
            throw this.readException;
        }
        if (n < 0) {
            throw new SQLException("Attempt to access a non-existent row.");
        }
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.rows.size() > n) {
                    return (byte[][])this.rows.get(n);
                }
                if (this.complete) {
                    throw new SQLException("Attempt to access a non-existent row.");
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void getRows() {
        while (true) {
            String string;
            byte[] byArray;
            try {
                byArray = this.connection.getInputStream().read();
            }
            catch (IOException iOException) {
                this.complete();
                this.readException = new MsqlException(iOException);
                return;
            }
            try {
                string = new String(byArray, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.complete();
                this.readException = new MsqlException(unsupportedEncodingException);
                return;
            }
            if (string.startsWith("-1:")) {
                this.complete();
                this.readException = new MsqlException(string);
                return;
            }
            if (string.startsWith("-100")) break;
            try {
                this.readRow(byArray);
            }
            catch (SQLException sQLException) {
                this.complete();
                this.readException = new MsqlException(sQLException);
                return;
            }
        }
        try {
            this.fieldInfo = new MsqlQueryData(null, 6, this);
            this.complete();
        }
        catch (SQLException sQLException) {
            this.readException = new MsqlException(sQLException);
            this.complete();
            this.fieldInfo = null;
        }
    }

    public String getString(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return null;
        }
        try {
            return new String(this.lastColumn, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlUnicodeInputStream(this.lastColumn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLast() throws SQLException {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.complete) {
                    return this.rowNumber == this.rows.size() - 1;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean next() throws SQLException {
        ++this.rowNumber;
        try {
            this.currentRow = this.getRow(this.rowNumber);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean previous() throws SQLException {
        throw new MsqlException("ResultSet is forward-only.");
    }

    private void readRow(byte[] byArray) throws SQLException {
        String string;
        byte[][] byArray2 = new byte[5][];
        try {
            string = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
        int n = 0;
        while (n < 5) {
            byte[] byArray3;
            if (n < 2) {
                byArray2[n] = null;
            } else if (n == 2) {
                byte[] byArray4;
                int n2;
                int n3 = string.indexOf(58);
                try {
                    n2 = Integer.parseInt(string.substring(0, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Invalid row data format from mSQL.");
                }
                if (n2 == -2) {
                    byArray4 = null;
                    n2 = 0;
                } else {
                    String string2 = string.substring(n3 + 1, n3 + n2 + 1);
                    try {
                        byArray4 = string2.getBytes("8859_1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new MsqlException(unsupportedEncodingException);
                    }
                }
                byArray2[n] = byArray4;
                string = string.substring(n3 + n2 + 1);
            } else if (n == 3) {
                byArray3 = new byte[]{84, 65, 66, 76, 69};
                byArray2[n] = byArray3;
            } else {
                byArray3 = new byte[]{78, 111};
                byArray2[n] = byArray3;
            }
            ++n;
        }
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.add(byArray2);
            this.rows.notifyAll();
        }
    }

    public boolean relative(int n) throws SQLException {
        throw new MsqlException("This result set is TYPE_FORWARD_ONLY.");
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.lastColumn == null;
    }
}

