/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlQueryData;
import com.imaginary.sql.msql.MsqlResultSet;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class MsqlStatement
implements Statement {
    private ArrayList batches = new ArrayList();
    private int columnCount = -1;
    private int concurrency = 1007;
    private MsqlConnection connection = null;
    private int fetchDirection = 1000;
    private boolean loaded = true;
    private int maxFieldSize = 0;
    private int maxRows = 0;
    private ArrayList resultSets = new ArrayList();
    private int updateCount = -1;
    private int type = 1003;

    MsqlStatement(MsqlConnection msqlConnection) {
        this(msqlConnection, 1003, 1007);
    }

    MsqlStatement(MsqlConnection msqlConnection, int n, int n2) {
        this.connection = msqlConnection;
        this.type = n;
        this.concurrency = n2;
    }

    public void addBatch(String string) throws SQLException {
        this.batches.add(string);
    }

    public void cancel() throws SQLException {
        this.closeAllResults();
    }

    public void clearBatch() throws SQLException {
        this.batches.clear();
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        this.closeAllResults();
    }

    private synchronized void closeAllResults() {
        while (!this.loaded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Iterator iterator = ((AbstractList)this.resultSets).iterator();
        while (iterator.hasNext()) {
            MsqlResultSet msqlResultSet = (MsqlResultSet)iterator.next();
            try {
                msqlResultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    synchronized void completeLoad() {
        this.connection.release();
        this.loaded = true;
        this.notifyAll();
    }

    public boolean execute(String string) throws SQLException {
        Object var2_2 = null;
        this.reset();
        this.connection.capture();
        AutoCloseable autoCloseable = this;
        synchronized (autoCloseable) {
            this.loaded = false;
        }
        if (!this.sendSQL(string)) {
            this.completeLoad();
            return false;
        }
        autoCloseable = new MsqlQueryData(this, this.columnCount);
        ArrayList arrayList = this.resultSets;
        synchronized (arrayList) {
            this.resultSets.add(autoCloseable);
        }
        return true;
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray = new int[this.batches.size()];
        int n = 0;
        while (n < this.batches.size()) {
            String string = (String)this.batches.get(n);
            try {
                nArray[n] = this.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
                batchUpdateException.setNextException(sQLException);
                throw batchUpdateException;
            }
            ++n;
        }
        return nArray;
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.reset();
        this.connection.capture();
        AutoCloseable autoCloseable = this;
        synchronized (autoCloseable) {
            this.loaded = false;
        }
        if (this.sendSQL(string)) {
            autoCloseable = new MsqlQueryData(this, this.columnCount);
            ArrayList arrayList = this.resultSets;
            synchronized (arrayList) {
                this.resultSets.add(autoCloseable);
                AutoCloseable autoCloseable2 = autoCloseable;
                Object var5_5 = null;
                return autoCloseable2;
            }
        }
        this.completeLoad();
        throw new SQLException("Non-query sent to executeQuery().");
    }

    public int executeUpdate(String string) throws SQLException {
        this.reset();
        this.connection.capture();
        MsqlStatement msqlStatement = this;
        synchronized (msqlStatement) {
            this.loaded = false;
        }
        if (!this.sendSQL(string)) {
            this.completeLoad();
            return this.updateCount;
        }
        new MsqlQueryData(this, this.columnCount);
        throw new SQLException("Query sent to executeUpdate().");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getEncoding() {
        return this.connection.getEncoding();
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.resultSets.size() > 0;
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = (ResultSet)this.resultSets.get(0);
        this.resultSets.remove(0);
        return resultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.type;
    }

    public int getUpdateCount() throws SQLException {
        int n = this.updateCount;
        this.updateCount = -1;
        return n;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    private synchronized void reset() {
        while (!this.loaded) {
            try {
                this.resultSets.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.clearWarnings();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.resultSets.clear();
        this.updateCount = -1;
        this.columnCount = -1;
    }

    private boolean sendSQL(String string) throws SQLException {
        String string2;
        try {
            this.connection.getOutputStream().writeString("3 " + string, this.getEncoding());
            string2 = this.connection.getInputStream().readString(this.getEncoding());
        }
        catch (IOException iOException) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw new MsqlException(iOException);
        }
        int n = string2.indexOf(58);
        if (n == -1) {
            this.completeLoad();
            throw new MsqlException("Incorrect mSQL response.");
        }
        int n2 = Integer.parseInt(string2.substring(0, n));
        if (n2 == -1) {
            this.completeLoad();
            throw new MsqlException(string2.substring(2));
        }
        n = string2.indexOf(58, 2);
        if (n == -1) {
            this.completeLoad();
            this.updateCount = n2;
            return false;
        }
        try {
            n2 = Integer.parseInt(string2.substring(2, n));
        }
        catch (NumberFormatException numberFormatException) {
            this.completeLoad();
            this.updateCount = -1;
            this.columnCount = -1;
            return false;
        }
        this.columnCount = n2;
        return true;
    }

    public void setCursorName(String string) throws SQLException {
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (bl) {
            throw new SQLException("Escape processing is not yet supported.");
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setQueryTimeout(int n) throws SQLException {
    }
}

