/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlColumn;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class MsqlResultSetMetaData
implements ResultSetMetaData,
Runnable {
    private ArrayList columns = new ArrayList();
    private boolean complete = false;
    private MsqlResultSet fieldResults = null;
    private SQLException loadException = null;

    MsqlResultSetMetaData(MsqlResultSet msqlResultSet) {
        this.fieldResults = msqlResultSet;
        new Thread(this).start();
    }

    public String getCatalogName(int n) throws SQLException {
        throw new MsqlException("mSQL does not support catalogs.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MsqlColumn getColumn(int n) throws SQLException {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            while (!this.complete) {
                try {
                    this.columns.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (n >= 1 && n <= this.columns.size()) {
            return (MsqlColumn)this.columns.get(n - 1);
        }
        throw new MsqlException("Invalid column check.");
    }

    public String getColumnClassName(int n) throws SQLException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getColumnCount() throws SQLException {
        ArrayList arrayList = this.columns;
        synchronized (arrayList) {
            while (true) {
                if (this.complete) {
                    return this.columns.size();
                }
                try {
                    this.columns.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getLength();
    }

    public String getColumnLabel(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        String string = System.getProperty("msql.oldlabels", "0");
        if (string.equals("1")) {
            return String.valueOf(msqlColumn.getTableName()) + "." + msqlColumn.getColumnName();
        }
        return msqlColumn.getColumnName();
    }

    public String getColumnName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getColumnName();
    }

    public int getColumnType(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        switch (msqlColumn.getType()) {
            case 4: {
                return "INT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 8: {
                return "MONEY";
            }
            case 7: {
                return "REAL";
            }
            case 92: {
                return "TIME";
            }
            case 12: {
                return "TEXT";
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                return "UNKNOWN";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
        }
        return "NULL";
    }

    public int getPrecision(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getLength();
    }

    public int getScale(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public String getTableName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getTableName();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }

    public int isNullable(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        if (msqlColumn.isNullable()) {
            return 1;
        }
        return 0;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    public void run() {
        try {
            Object object;
            while (this.fieldResults.next()) {
                boolean bl;
                boolean bl2;
                String string;
                object = this.fieldResults.getString(1);
                String string2 = this.fieldResults.getString(2);
                int n = this.fieldResults.getInt(3);
                int n2 = this.fieldResults.getInt(4);
                try {
                    string = this.fieldResults.getString(5);
                    bl2 = !string.equals("Y");
                }
                catch (SQLException sQLException) {
                    bl2 = true;
                }
                try {
                    string = this.fieldResults.getString(6);
                    bl = string.equals("Y");
                }
                catch (SQLException sQLException) {
                    bl = false;
                }
                this.columns.add(new MsqlColumn(string2, (String)object, n, n2, bl2, bl));
            }
            object = this.columns;
            synchronized (object) {
                this.complete = true;
                this.columns.notifyAll();
            }
        }
        catch (SQLException sQLException) {
            ArrayList arrayList = this.columns;
            synchronized (arrayList) {
                this.loadException = sQLException;
                this.complete = true;
                this.columns.notifyAll();
            }
        }
    }
}

