/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlStatement;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public abstract class MsqlResultSet
implements ResultSet {
    private int concurrency = 1007;
    private int fetchDirection = 1000;
    private MsqlStatement statement = null;
    private int type = 1003;

    MsqlResultSet(MsqlStatement msqlStatement) throws SQLException {
        this.statement = msqlStatement;
        if (msqlStatement != null) {
            this.fetchDirection = msqlStatement.getFetchDirection();
            this.concurrency = msqlStatement.getResultSetConcurrency();
            this.type = msqlStatement.getResultSetType();
        }
    }

    public abstract boolean absolute(int var1) throws SQLException;

    public void afterLast() throws SQLException {
        this.absolute(-1);
        this.next();
    }

    public void beforeFirst() throws SQLException {
        this.absolute(1);
        this.previous();
    }

    public void cancelRowUpdates() throws SQLException {
        throw new MsqlException("Only CONCUR_READ_ONLY is supported.");
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public void complete() {
        if (this.statement != null) {
            this.statement.completeLoad();
        }
    }

    public void deleteRow() throws SQLException {
        throw new MsqlException("Only CONCUR_READ_ONLY is supported.");
    }

    public abstract int findColumn(String var1) throws SQLException;

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public abstract InputStream getAsciiStream(int var1) throws SQLException;

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"));
        }
        return new BigDecimal(new BigInteger(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
        return new BigDecimal(new BigInteger(string), n2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public abstract InputStream getBinaryStream(int var1) throws SQLException;

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public abstract boolean getBoolean(int var1) throws SQLException;

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public abstract byte getByte(int var1) throws SQLException;

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public abstract byte[] getBytes(int var1) throws SQLException;

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return new CharArrayReader(this.getString(n).toCharArray());
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("mSQL does not support cursors.");
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid date format.");
            }
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            simpleDateFormat.setCalendar(calendar);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MsqlException("Invalid date format.");
            }
        }
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public String getEncoding() {
        if (this.statement != null) {
            return this.statement.getEncoding();
        }
        return "8859_1";
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Character((char)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, 0);
            }
            case 3: {
                return this.getBigDecimal(n, 0);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return this.getObject(n, (Map)this.statement.getConnection().getTypeMap());
            }
        }
        throw new MsqlException("Unknown SQL type: " + n2);
    }

    public Object getObject(int n, Map map) throws SQLException {
        SQLData sQLData;
        Class clazz;
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        String string = resultSetMetaData.getColumnTypeName(n);
        SQLInput sQLInput = null;
        if (!map.containsKey(string)) {
            switch (resultSetMetaData.getColumnType(n)) {
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: {
                    throw new MsqlException("No type mapping defined for" + string + ".");
                }
            }
            return this.getObject(n);
        }
        try {
            clazz = (Class)map.get(string);
        }
        catch (ClassCastException classCastException) {
            throw new MsqlException(classCastException);
        }
        try {
            sQLData = (SQLData)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new MsqlException(exception);
        }
        sQLData.readSQL(sQLInput, string);
        return sQLData;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public abstract int getRow() throws SQLException;

    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MsqlException(numberFormatException);
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public abstract String getString(int var1) throws SQLException;

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Time(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid time format.");
            }
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            simpleDateFormat.setCalendar(calendar);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Time(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQLException("Invalid time format.");
            }
        }
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(Long.parseLong(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(Long.parseLong(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getType() throws SQLException {
        return this.type;
    }

    public abstract InputStream getUnicodeStream(int var1) throws SQLException;

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        throw new MsqlException("Only CONCUR_READ_ONLY is supported.");
    }

    public boolean isAfterLast() throws SQLException {
        return this.getRow() == 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public abstract boolean isLast() throws SQLException;

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        throw new MsqlException("Only CONCUR_READ_ONLY is supported.");
    }

    public abstract boolean next() throws SQLException;

    public abstract boolean previous() throws SQLException;

    public void refreshRow() throws SQLException {
        throw new MsqlException("Only CONCUR_READ_ONLY is supported.");
    }

    public abstract boolean relative(int var1) throws SQLException;

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    void setConcurrency(int n) {
        this.concurrency = n;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public void setType(int n) {
        this.type = n;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateNull(int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateNull(String string) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateRow() throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new MsqlException("This operation is not supported.");
    }

    public abstract boolean wasNull() throws SQLException;
}

