/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlAsciiInputStream;
import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlResultSet;
import com.imaginary.sql.msql.MsqlResultSetMetaData;
import com.imaginary.sql.msql.MsqlStatement;
import com.imaginary.sql.msql.MsqlUnicodeInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class MsqlQueryData
extends MsqlResultSet {
    private final int columnCount;
    private HashMap columnMap = null;
    private boolean complete = false;
    private byte[][] currentRow = null;
    private MsqlQueryData fieldInfo = null;
    protected byte[] lastColumn = null;
    private ResultSetMetaData metaData = null;
    private MsqlResultSet owningSet = null;
    private MsqlException readException = null;
    private int rowNumber = -1;
    private ArrayList rows = new ArrayList();

    MsqlQueryData(MsqlStatement msqlStatement, int n) throws SQLException {
        this(msqlStatement, n, null);
    }

    MsqlQueryData(MsqlStatement msqlStatement, int n, MsqlResultSet msqlResultSet) throws SQLException {
        super(msqlStatement);
        this.columnCount = n;
        this.owningSet = msqlResultSet;
        if (msqlResultSet != null) {
            this.loadResults();
            this.setConcurrency(msqlResultSet.getConcurrency());
            this.setType(msqlResultSet.getType());
        } else {
            Thread thread = new Thread(){

                public void run() {
                    MsqlQueryData.this.loadResults();
                }
            };
            thread.setPriority(4);
            thread.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean absolute(int n) throws SQLException {
        if (this.getType() == 1003) {
            throw new MsqlException("Result set is TYPE_FORWARD_ONLY.");
        }
        if (n > 0) {
            this.rowNumber = n - 1;
        } else {
            if (n >= 0) throw new MsqlException("Cannot move to the 0th row.");
            ArrayList arrayList = this.rows;
            synchronized (arrayList) {
                while (!this.complete) {
                    try {
                        this.rows.wait(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.rowNumber = this.rows.size() + n;
        }
        try {
            this.currentRow = this.getRow(this.rowNumber);
            return true;
        }
        catch (SQLException sQLException) {
            this.rowNumber = -1;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.complete) {
                    if (this.owningSet != null) return;
                    if (this.fieldInfo == null) return;
                    this.fieldInfo.close();
                    return;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void complete() {
        if (this.owningSet != null) {
            ArrayList arrayList = this.rows;
            synchronized (arrayList) {
                this.complete = true;
                this.rows.notifyAll();
            }
        }
        super.complete();
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            this.complete = true;
            this.rows.notifyAll();
        }
    }

    private byte[] copyBytes(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n + n3];
            ++n3;
        }
        return byArray2;
    }

    public synchronized int findColumn(String string) throws SQLException {
        String string2;
        int n;
        Object object;
        if (this.columnMap == null) {
            object = this.getMetaData();
            this.columnMap = new HashMap();
            n = 1;
            while (n <= this.columnCount) {
                string2 = String.valueOf(object.getTableName(n)) + "." + object.getColumnName(n);
                this.columnMap.put(string2, new Integer(n));
                ++n;
            }
        }
        if (!this.columnMap.containsKey(string)) {
            object = this.columnMap.keySet().iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                n = string2.indexOf(".");
                String string3 = n == -1 ? string2 : (n >= string2.length() - 1 ? string2.substring(0, n) : string2.substring(n + 1));
                if (!string3.equals(string)) continue;
                return (Integer)this.columnMap.get(string2);
            }
            throw new MsqlException("Invalid column name: " + string);
        }
        return (Integer)this.columnMap.get(string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlAsciiInputStream(this.lastColumn);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.getColumn(n);
        return new ByteArrayInputStream(this.lastColumn);
    }

    public boolean getBoolean(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return false;
        }
        if (this.lastColumn.length == 0) {
            return false;
        }
        return this.lastColumn[0] != 48 && this.lastColumn[0] != 0;
    }

    public byte getByte(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return 0;
        }
        return this.lastColumn[0];
    }

    public byte[] getBytes(int n) throws SQLException {
        this.getColumn(n);
        return this.lastColumn;
    }

    protected void getColumn(int n) throws SQLException {
        try {
            this.lastColumn = this.currentRow[n - 1];
        }
        catch (Exception exception) {
            if (this.currentRow == null) {
                throw new MsqlException("-1:Result set cursor is positioned outside of the result set.");
            }
            throw new MsqlException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            if (this.metaData != null) {
                return this.metaData;
            }
            while (true) {
                if (this.fieldInfo != null) {
                    this.metaData = new MsqlResultSetMetaData(this.fieldInfo);
                    return this.metaData;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getRow() throws SQLException {
        return this.rowNumber + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[][] getRow(int n) throws SQLException {
        this.clearWarnings();
        if (n < 0) {
            throw new MsqlException("Attempt to access a non-existent row.");
        }
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            if (this.readException != null) {
                throw this.readException;
            }
            while (true) {
                if (this.rows.size() > n) {
                    return (byte[][])this.rows.get(n);
                }
                if (this.complete) {
                    throw new MsqlException("Attempt to access a non-existent row.");
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String getString(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return null;
        }
        try {
            return new String(this.lastColumn, this.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.getColumn(n);
        return new MsqlUnicodeInputStream(this.lastColumn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLast() throws SQLException {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.complete) {
                    return this.rowNumber == this.rows.size() - 1;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void loadResults() {
        Object object;
        while (true) {
            String string;
            try {
                MsqlStatement msqlStatement = (MsqlStatement)this.getStatement();
                MsqlConnection msqlConnection = (MsqlConnection)msqlStatement.getConnection();
                object = msqlConnection.getInputStream().read();
            }
            catch (Exception exception) {
                this.complete();
                this.readException = new MsqlException(exception);
                return;
            }
            try {
                string = new String((byte[])object, this.getEncoding());
            }
            catch (Exception exception) {
                this.complete();
                this.readException = new MsqlException(exception);
                return;
            }
            if (string.startsWith("-1:")) {
                this.readException = new MsqlException(string);
                return;
            }
            if (string.startsWith("-100")) break;
            try {
                this.readRow((byte[])object);
            }
            catch (Exception exception) {
                this.complete();
                this.readException = new MsqlException(exception);
                return;
            }
        }
        if (this.owningSet == null) {
            try {
                object = (MsqlStatement)this.getStatement();
                this.fieldInfo = new MsqlQueryData((MsqlStatement)object, 6, this);
                this.complete();
            }
            catch (SQLException sQLException) {
                this.complete();
                this.readException = new MsqlException(sQLException);
                this.fieldInfo = null;
            }
        } else {
            this.complete();
        }
    }

    public boolean next() throws SQLException {
        ++this.rowNumber;
        try {
            this.currentRow = this.getRow(this.rowNumber);
        }
        catch (SQLException sQLException) {
            this.rowNumber = -1;
            return false;
        }
        return true;
    }

    private int nextBreak(byte[] byArray, int n) {
        int n2 = n;
        while (n2 < byArray.length) {
            if (byArray[n2] == 58) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new MsqlException("ResultSet is forward-only.");
        }
        --this.rowNumber;
        try {
            this.currentRow = this.getRow(this.rowNumber);
        }
        catch (SQLException sQLException) {
            this.rowNumber = -1;
            return false;
        }
        return true;
    }

    private void readRow(byte[] byArray) throws SQLException {
        ArrayList arrayList;
        byte[][] byArray2 = new byte[this.columnCount][];
        int n = 0;
        int n2 = 0;
        while (n2 < this.columnCount) {
            int n3;
            int n4 = this.nextBreak(byArray, n);
            if (n4 == n) {
                byArray2[n2] = new byte[0];
                n3 = 0;
                ++n;
            } else {
                try {
                    String string = new String(byArray, n, n4 - n, "8859_1");
                    n3 = Integer.parseInt(string);
                    if (n3 == -2) {
                        arrayList = null;
                        n3 = 0;
                    } else {
                        byArray2[n2] = this.copyBytes(byArray, n4 + 1, n3);
                    }
                    n = n4 + n3 + 1;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SQLException("Invalid mSQL row data format.");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new MsqlException(unsupportedEncodingException);
                }
            }
            ++n2;
        }
        arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.add(byArray2);
            this.rows.notifyAll();
        }
    }

    public boolean relative(int n) throws SQLException {
        if (this.getType() == 1003) {
            throw new MsqlException("Row set is TYPE_FORWARD_ONLY.");
        }
        if (this.rowNumber == -1) {
            throw new MsqlException("No current row is set.");
        }
        this.rowNumber += n;
        try {
            this.currentRow = this.getRow(this.rowNumber);
        }
        catch (SQLException sQLException) {
            this.rowNumber = -1;
            return false;
        }
        return true;
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumn == null;
    }
}

