/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlEmptyResultSet;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlOutputStream;
import com.imaginary.sql.msql.MsqlTableList;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MsqlDatabaseMetaData
implements DatabaseMetaData {
    private MsqlConnection connection = null;

    MsqlDatabaseMetaData(MsqlConnection msqlConnection) {
        this.connection = msqlConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public String getCatalogSeparator() throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public String getCatalogTerm() throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public ResultSet getCatalogs() throws SQLException {
        throw new SQLException("mSQL does not support catalogs");
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        throw new SQLException("This makes no sense.");
    }

    public String getDatabaseProductName() throws SQLException {
        return "miniSQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.connection.versionString;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public String getDriverName() throws SQLException {
        return "Imaginary JDBC Driver for mSQL";
    }

    public String getDriverVersion() throws SQLException {
        return "2.0a1";
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 1;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 4096;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 24;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 8;
    }

    public String getNumericFunctions() throws SQLException {
        if (this.connection.version == 2) {
            return "";
        }
        return "";
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        throw new SQLException("mSQL does not support stored procedures.");
    }

    public String getProcedureTerm() throws SQLException {
        throw new SQLException("mSQL does not support procedures.");
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        throw new SQLException("mSQL does not support stored procedures.");
    }

    public String getSQLKeywords() throws SQLException {
        return "";
    }

    public String getSchemaTerm() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public ResultSet getSchemas() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public ResultSet getTableTypes() throws SQLException {
        return null;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        MsqlOutputStream msqlOutputStream = this.connection.getOutputStream();
        this.connection.capture();
        try {
            msqlOutputStream.writeString("5\n", this.connection.getEncoding());
        }
        catch (IOException iOException) {
            this.connection.release();
            throw new MsqlException(iOException);
        }
        return new MsqlTableList(this.connection, string3);
    }

    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    public ResultSet getTypeInfo() throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public String getURL() throws SQLException {
        return this.connection.url;
    }

    public String getUserName() throws SQLException {
        return this.connection.user;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        return new MsqlEmptyResultSet();
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw new SQLException("mSQL does not support catalogs or procs.");
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support catalogs.");
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.connection.version == 2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return this.connection.version == 2;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (n2 != 1007) {
            return false;
        }
        return this.supportsResultSetType(n);
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n != 1005;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        throw new SQLException("mSQL does not support schemas.");
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return this.connection.version == 2;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return this.connection.version == 2;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return true;
    }

    public boolean usesLocalFiles() throws SQLException {
        return true;
    }
}

