/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlDatabaseMetaData;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlOutputStream;
import com.imaginary.sql.msql.MsqlPreparedStatement;
import com.imaginary.sql.msql.MsqlStatement;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MsqlConnection
implements Connection {
    private Socket connection = null;
    private String encoding = "8859_1";
    private boolean inUse = false;
    protected MsqlInputStream input = null;
    protected MsqlOutputStream output = null;
    private ArrayList statements = new ArrayList();
    private Map typeMap = new HashMap();
    protected String url = null;
    protected String user = null;
    protected int version = 0;
    protected String versionString = null;

    MsqlConnection(String string, String string2, int n, String string3, Properties properties) throws SQLException {
        Object object;
        this.url = string;
        this.user = (String)((Hashtable)properties).get("user");
        if (this.user == null || this.user.equals("")) {
            this.user = "nobody";
        }
        this.connect(string2, n, this.user);
        this.selectDatabase(string3);
        this.encoding = (String)((Hashtable)properties).get("encoding");
        if (this.encoding == null) {
            this.encoding = "8859_1";
        } else {
            try {
                object = new byte[]{112};
                String string4 = new String((byte[])object, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        object = new Thread(){

            public void run() {
                while (!MsqlConnection.this.isClosed()) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                MsqlConnection.this.cleanStatements();
            }
        };
        object.setPriority(1);
        object.setDaemon(true);
        object.start();
    }

    private void DEBUG(String string) {
        System.out.println("MsqlConnection: " + string);
    }

    synchronized void capture() {
        while (this.isInUse()) {
            try {
                this.wait(1500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.inUse = true;
    }

    private synchronized void clean() {
        Iterator iterator = ((AbstractList)this.statements).iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Statement statement = (Statement)weakReference.get();
            if (statement == null) continue;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        this.statements.clear();
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
            this.input = null;
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
            this.output = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {}
            this.connection = null;
        }
        this.user = null;
        this.release();
    }

    private synchronized void cleanStatements() {
        Iterator iterator = ((AbstractList)this.statements).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() == null) {
                this.statements.remove(n);
            }
            ++n;
        }
    }

    public void clearWarnings() throws SQLException {
    }

    public synchronized void close() throws SQLException {
        IOException iOException = null;
        if (this.isClosed()) {
            throw new SQLException("This connection is already closed.");
        }
        this.capture();
        try {
            this.output.writeString("1", this.encoding);
            this.output.flush();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.clean();
        if (iOException != null) {
            throw new MsqlException(iOException);
        }
    }

    public void commit() throws SQLException {
    }

    private synchronized void connect(String string, int n, String string2) throws SQLException {
        try {
            this.capture();
            this.connection = new Socket(string, n);
            this.input = new MsqlInputStream(this.connection.getInputStream());
            this.output = new MsqlOutputStream(this.connection.getOutputStream());
            String string3 = this.input.readString(this.encoding);
            if (string3.startsWith("0:22:") || string3.startsWith("0:23:")) {
                this.version = 2;
                this.versionString = string3.substring(5);
            } else if (string3.startsWith("0:6:")) {
                this.version = 1;
                this.versionString = string3.substring(4);
            } else {
                this.clean();
                throw new SQLException("Unsupported mSQL version.");
            }
            this.output.writeString(string2, this.encoding);
            string3 = this.input.readString(this.encoding);
            if (!string3.startsWith("-100:")) {
                this.clean();
                throw new SQLException("Access to server denied.");
            }
        }
        catch (IOException iOException) {
            this.clean();
            throw new SQLException("Connection failed: " + iOException.getMessage());
        }
        this.release();
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        MsqlStatement msqlStatement = new MsqlStatement(this, n, n2);
        WeakReference<MsqlStatement> weakReference = new WeakReference<MsqlStatement>(msqlStatement);
        this.statements.add(weakReference);
        return msqlStatement;
    }

    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    MsqlInputStream getInputStream() {
        return this.input;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new MsqlDatabaseMetaData(this);
    }

    MsqlOutputStream getOutputStream() {
        return this.output;
    }

    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    public Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public synchronized String getUser() throws SQLException {
        return this.user;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public synchronized boolean isClosed() {
        return this.connection == null;
    }

    synchronized boolean isInUse() {
        return this.inUse;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        throw new SQLException("mSQL does not support stored procedures.");
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new SQLException("mSQL does not support stored procedures.");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        MsqlPreparedStatement msqlPreparedStatement = new MsqlPreparedStatement(this, string, n, n2);
        WeakReference<MsqlPreparedStatement> weakReference = new WeakReference<MsqlPreparedStatement>(msqlPreparedStatement);
        this.statements.add(weakReference);
        return msqlPreparedStatement;
    }

    synchronized void release() {
        this.inUse = false;
        this.notifyAll();
    }

    public void rollback() throws SQLException {
        throw new SQLException("mSQL exception: mSQL does not support rollbacks.");
    }

    private synchronized void selectDatabase(String string) throws MsqlException {
        this.capture();
        try {
            this.output.writeString("2 " + string, this.encoding);
            String string2 = this.input.readString(this.encoding);
            if (string2.startsWith("-1:")) {
                this.clean();
                throw new MsqlException(string2);
            }
        }
        catch (IOException iOException) {
            this.clean();
            throw new MsqlException(iOException);
        }
        this.release();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (!bl) {
            throw new SQLException("mSQL must always be auto-commit = true.");
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (bl) {
            throw new MsqlException("mSQL does not support read-only mode.");
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }
}

