import java.io.*;
import java.util.*;

public class Score extends Observable implements Serializable  {
  Integer score;
  static Score[] hi_scores = new Score[10];
  String name;
  


  public  Score(String name,Integer val) {
    this.name = new String(name);
    score = val;
  }

  public Score(String name) {
    this.name=name;
    score = new Integer("0");
    //readHiScores();
  }
  public Score() {
    name = new String("Player");
    score = new Integer("0");
    readHiScores();
   
  }
  
 

  public void setName(String name) {
    this.name=name;
  }
  public String getScoreValue() {
    return score.toString();
  }
  public void set(int nb) {
     score = new Integer(nb);
    
    

  }
  public void incremente(int val) {
    score = new Integer(score.intValue() + val);
    
    
    
  }
  
  public int getIntValue() {
    return score.intValue();
  }

  public void reset() {
    score = new Integer("0");   
   
  }

  public String toString () {
    return new String("score");
  }
  public void writeHiScores() {
    

    try {
      ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream ("./data/score.dat"));
      for ( int i=0; i< 10;i++) {
	oos.writeObject(hi_scores[i]);

      }
    }
    catch (IOException e) {
         System.out.println("Can't write score.dat ");
    }
    
  }

public String getHiScoreName(int i) {
	
	return new String(hi_scores[i].name);
  }

  public String getHiScoreVal(int i) {

    return new String(hi_scores[i].getScoreValue());
  }


  public void readHiScores() {
    try {
      ObjectInputStream ois = new ObjectInputStream(new FileInputStream ("./data/score.dat"));
      for (int i=0; i< 10;i++) {
	hi_scores[i]=(Score)ois.readObject();
      }
      
      
    }
    catch (Exception e) {
      //System.out.println("Cant't read hi-scores file : score.dat");
      initHiScores();
    }
    
  }

  public void initHiScores() {
       
    for ( int i=0; i< 10;i++) {
      hi_scores[i]=new Score("anonymous");
    }
  }

  public void enterHiScores() {
    int s=0;
    Score hiscore = this;
    Score tmp;
    
    while ((s < 10) &&( this.getIntValue() < hi_scores[s].getIntValue()))
	{

      s++;
    }
    if (s < 10) {
      setChanged();
      notifyObservers();

      for (int i=s; i < 10; i++) {
	tmp=hi_scores[i];

	hi_scores[i]=new Score(hiscore.name,hiscore.score);
	hiscore=tmp;
      }
    }
    
    
  }
  
	

  public static void main(String arg[]) {
    Score sc=new Score("Me");
    
    sc.initHiScores();
    sc.writeHiScores();
    
  }
}

