import java.awt.*;

/** 
 * Projecteur class. Cette classe fournit un canvas affichant 
 * a intervalles reguliers la scene.
 */

public class Projecteur extends Canvas implements Runnable 

{
  /**
   * La largeur et la hauteur  du canvas
   */
  private int width;
  private int height;
  
  /** 
   * L'afficheur permettant de construire l'image a afficher
   */
  private Afficheur afficheur=null;
  
  /**
   * temps en millisecondes entre chaque frame
   */
  private int rafraichissement;

  /**
   * Le thread se chargeant d'afficher l'image 
   */
  private volatile Thread t;
  private boolean threadSuspended = true;

  /** Pour le double buffer
   */
  private Graphics offGraphics ;//double buffer
  private Image offImage;
  private Graphics offGridgc;//buffer pour la grille du pacman
  private Image offGrid;
  
  /** la taille du double buffer
   */
  private Dimension offDimension;


  /** Le constructeur initialise la taille et le temps de rafraichissement
   * du canvas, positionne l'afficheur et lance le thread
   */
  public Projecteur(Afficheur afficheur)
  {
    this.afficheur = afficheur;
    
    rafraichissement = 40;
    
    width=510;
    height=360;
    
    start();

  }
  
 
  public synchronized void stop() {
    t = null;
    notify();
    threadSuspended = !threadSuspended;
    repaint();
  }

  public synchronized void start(){
    t = new Thread(this);
    threadSuspended = !threadSuspended;
    t.start();
  }

  public void suspend() {
    t.suspend();
  }
   
  public void resume() {
    t.resume();
 }
  
  /** Tache de fond executee par le Thread. Effectuant l'animation du jeu
   * en invoquant repaint() a intervalles reguliers
   */
  public void run() {
        Thread thisThread = Thread.currentThread();
        while (t == thisThread) {
	  try {
	    
	    if (threadSuspended)
	      synchronized(this) {
	      while (threadSuspended && t==thisThread)
		wait();
	    }
	    else
	      {
		
		repaint();
		thisThread.sleep(rafraichissement);
	      }
	  }

	  catch (InterruptedException e){
	  }
	}
  }
    
  
  /** Retourne le temps entre chaque frame d'animation
   */
  public int getRafraichissement() {
    return rafraichissement;
  }

  /** Positionne le temps entre chaque frame d'animation
   */
  public void setRafraichissement(int tps){
    rafraichissement=tps;
  }


  /** La fonction paint appelle directement update pour le
   * double buffering
   */
  public void paint(Graphics g) {
    
    update(g);
  }

  
  
  public void update(Graphics g) {
    
    Dimension d = getSize();

    //Creer le contexte graphics 'offscreen', s'il n'existe pas encore
    if (offGraphics == null) 
	
      {

      offDimension = d;
      offImage = createImage(d.width, d.height);
      offGraphics = offImage.getGraphics();
      
      // Image contenant la grille du Jeu
      offGrid=createImage(420,340);
      offGridgc=offGrid.getGraphics();
      afficheur.setImage(offGrid);

      }
    
    // On ajuste la taille du double buffer si la fenetre est retaillee
    if ((d.width != offDimension.width)
	|| (d.height != offDimension.height))
      {offDimension = d;
      offImage = createImage(d.width, d.height);
      offGraphics = offImage.getGraphics();}
	
    //Efface l'ancienne image
    offGraphics.setColor(Color.black);
    offGraphics.fillRect(0, 0, d.width, d.height);
    
        
    // Appel de la methode se chargeant de construire l'image dans le double
    // buffer
    afficheur.constructScene(offGraphics);
    
    
    //Dessine l'image a l'ecran
    g.drawImage(offImage, 10, 10,d.width,d.height,this);
  }
}

  

  


    






