
/** Pacman class. Definit les caracteristiques d'un pacman
 * le pacman  se deplace en tache de fond  a 
 * intervalle de temps reguliers
 */

public class Pacman extends Acteur implements Runnable 
{

  private boolean alive; 


  private volatile Thread t;
  private boolean threadSuspended = true;
  
  // vitesse de deplacement du pacman
   static int vitesse=60;
  
  // strategie attachee au pacman
  private Strategie strategie;

  // entier representant l'etat du pacman
  private int state;
  
 
    public Pacman()
    
    {
    super(new Position(200,200),true,4); 
    alive=true;
   
    state=0;
  
    }

  /** Positionne la strategie du pacman lui permettant de
   * definir sa nouvelle position
   */
  
   public void setStrategie(Strategie strategie) {
    this.strategie=strategie;
  }

  /** Positionne la vitesse de deplacemant du pacman
   */
  public static void setVitesse(int vit) {

    if ((vit >= 20) && (vit <= 300))
      vitesse=vit;


  }

  // repositionne les attributs du pacman 
  public void resetPosition() {
    setStartPosition();
    setEatable(true);
  }
  
   // suspend le thread
  public void suspend() {
    threadSuspended = true;
  }
   // reprend l'execution du thread  
  public void resume() {
    threadSuspended=false;
    //  notify();
  }

   // termine l'execution du thread
  public void terminate() {
    t=null;
  }

  // lance l'execution du thread
   public synchronized void start()
  {
    t=new Thread(Acteur.tg ,this);
    threadSuspended = !threadSuspended;
    t.start();
  }
  
  
  public String getName() {
    return "Pacman";
  }
 // renvoie un entier representant l'etat actuel du pacman
  public int getIndex() {
    return state;
  }
  
  // effectue les actions necessaires lorsque le pacman s'est
  // fait manger
  
  public void kill() {
    
    setStartPosition();
    
  }
  
   

 
  // on calcule un entier representant l'etat du pacman
  private void computeIndex() {
    if (Math.random() > 0.9)
      state=1;
    else
      state=0;
     

    switch (strategie.getDirection()) {
	
    case 'N' :state=state+4;break;
    case 'S' :state=state+6;break;
    case 'W' :state=state+0;break;
    case 'E' :state=state+2;break;
    default:}
    
    }
  
  // La tache de fond executee par le pacman
  
   public void run() {
        Thread thisThread = Thread.currentThread();
        while (t == thisThread) {

	  try {
	    
	    if (threadSuspended)
	      synchronized(this) {
	      while (threadSuspended && t==thisThread)
		t.sleep(40);
	    }
	    else
	      {
		
		
		// on demande a la strategie une nouvelle position
		position=strategie.move(getPosition());
		// on calcule l'index 
		computeIndex();
		
		// on avertit l'observer
		setChanged();
		notifyObservers();

		// on dort pendant vitesse milisecondes
		thisThread.sleep(vitesse);
		
		
		
	      }
	  }

	  catch (InterruptedException e){
	  }
	}
   }
}
