import java.awt.*;
import java.awt.event.*;
import java.util.*;

/** PacInterface class. L'interface graphique du jeu
 */

public class PacInterface {

  private Projecteur projecteur;
  
  private Afficheur afficheur;
  
  Frame frame;
  
  Scrollbar sb1;

  public PacInterface(PacGame pacGame,Game game) {
  
    // la frame principale
    frame = new Frame();
	frame.setForeground(Color.white);	
    // la barre de menu
    MenuBar menubar= new MenuBar();

    // les differents menus
    Menu menu = new Menu("Game");
    MenuItem menuitem1 = new MenuItem("New Game");
    menuitem1.setActionCommand("Start");
    menuitem1.addActionListener(pacGame);
    menu.add(menuitem1);
    MenuItem menuitem2 = new MenuItem("Pause");
    menuitem2.setActionCommand("Pause");
    menuitem2.addActionListener(pacGame);
    menu.add(menuitem2);
    
  

    MenuItem menuitem4 = new MenuItem("Quit");
    menuitem4.setActionCommand("Quit");
    menuitem4.addActionListener(pacGame);
    menu.add(menuitem4);

    Menu menu2 = new Menu("Others");
    MenuItem help = new MenuItem("Help");
    help.setActionCommand("Help");
    help.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	new helpDialog(frame,true);
      }});
	
       
    menu2.add(help);
    menubar.add(menu);
    menubar.add(menu2);

    frame.setLayout(new BorderLayout());
    Panel panelchoice = new Panel();
    panelchoice.setBackground(Color.black);
    
    // Choix du niveau de difficulte
    
    Choice LevelChooser = new Choice();
    LevelChooser.setForeground(Color.white);
    LevelChooser.add("Easy");
    LevelChooser.add("Normal");
    LevelChooser.add("Hard");
    LevelChooser.add("Demo");

    LevelChooser.addItemListener(pacGame);
    
    // choix du nombre de fantomes
    
    Choice GhostChooser = new Choice();
    GhostChooser.setForeground(Color.white);
    GhostChooser.add("1");
    GhostChooser.add("2");
    GhostChooser.add("3");
    GhostChooser.add("4"); 
    GhostChooser.add("5");
    GhostChooser.add("6");
    GhostChooser.add("7");
    GhostChooser.add("8");
    GhostChooser.select("4");
    GhostChooser.addItemListener(pacGame);
    
    
    panelchoice.add(new Label("Difficulty :",Label.RIGHT));
    panelchoice.add(LevelChooser);
    panelchoice.add(new Label("nb of ghosts :",Label.CENTER));
    panelchoice.add(GhostChooser);
    
    // Scrollbar pour regler la vitesse de deplacement des acteurs

    panelchoice.add(new Label("Speed :",Label.LEFT));
    panelchoice.add(new Label("Slower"));
    sb1 = new Scrollbar(Scrollbar.HORIZONTAL);
    sb1.setMaximum(280);
    sb1.setMinimum(0);
    
    sb1.setBlockIncrement(10);
    
    sb1.setUnitIncrement(10);

    // Position de depart de l'onglet
    sb1.setValue(140);

    // Pour gerer les evenements, on utilise une classe interne anonyme
    sb1.addAdjustmentListener(
			      new AdjustmentListener() {
      public  void adjustmentValueChanged(AdjustmentEvent e) {
	sb1.setValue(e.getValue());
	
	Game.setSpeed(300 - e.getValue());
	
      }
    }
		    
			      );
    
    panelchoice.add("South",sb1);
    panelchoice.add(new Label("Faster"));
		    
		    
    
    frame.add("North",panelchoice);
    
   
    frame.setMenuBar(menubar);
    
    // l'afficheur du jeu
    afficheur = new Afficheur (new MediaTracker((Component)frame),game);

    // le canvas projecteur 
    projecteur = new Projecteur(afficheur);

    projecteur.addKeyListener(pacGame);

    frame.add("Center",projecteur);



    
    frame.setBackground(Color.black);
    frame.addWindowListener(pacGame);
	
    frame.setBounds(20,20,580,460);

    frame.setTitle("PaCmAn");

    frame.show();
    
    frame.setVisible(true);


    projecteur.requestFocus();
    
    }
  
  public Projecteur getProjecteur() {
    return projecteur;
  }
  public Afficheur getAfficheur() {
    return afficheur;
  }


  

}

  
  
