import java.io.*;
import java.net.*;
import java.util.*;

/** PacGrid class. Cette classe lit le labyrinthe a partir d'un fichier
 * et charge celui-ci dans un tableau a deux dimensions.
 * La grille est observee par l'afficheur.
 */

public class PacGrid extends Observable

{
  private int nb_colonnes;
  private int nb_lignes;
  
  // la taille d'un element
  public int square_size;

  // le tableau ou est stocke le labyrinthe
  private int grid[][];

  // le tableau ou sont stockes les patgums
  private int patgrid[][];

  // le nombre de patgums restantes
  private int nb_gums_left;

  // le nombre de labyrinthe differents
  private int nb_grids;

  // le labyrinthe courant
  private int current_grid;
 
 
  
  public PacGrid()
  {
    this.nb_colonnes=21;
    this.nb_lignes=17;
    this.square_size=20;
    grid = new int[nb_colonnes][nb_lignes];
    patgrid = new int[nb_colonnes][nb_lignes];
    nb_gums_left =0;
    this.nb_grids =2;
    current_grid=0;
    
  }


  /** Charge en memoire le prochain labyrinthe a partir des fichiers
   * du repertoire data
   */
  
  public void nextLevel() { 
    FileInputStream  fis= null;
    if (current_grid < nb_grids)
      current_grid++;
    try
      {

	fis = new FileInputStream("./data/PacGrid"+current_grid+".txt");
	readGrid(fis,grid,patgrid);
	fis = null;
      }
    catch (IOException e)
      {
	System.out.println("Erreur lors de l'ouverture du fichier grille ");
	e.printStackTrace();
      }
  }

  public void resetLevel() {
    current_grid= 0;
  }

  /** Chargement du fichier en memeoire
   */
  private void readGrid(FileInputStream  fis,int tab[][],int pattab[][]) throws IOException 
  {
    boolean reading;
    StreamTokenizer st = null;
    boolean patgrid= false;
    int column = 0;
    int line = 0;
    int valeur;
    try
      {
	Reader r = new BufferedReader(new InputStreamReader(fis));
	st = new StreamTokenizer(r);
	st.eolIsSignificant(true);
      }
    catch (Exception e) 
      {
      }
    reading = true;
    nb_gums_left=0;
    while ((reading == true) && (line < nb_lignes))
      { 
	switch (st.nextToken())
	  {
	  case StreamTokenizer.TT_EOL:
	    {
	      column=0;
	      line++;
	      if (line == nb_lignes) 
		{
		  patgrid=true;
		  line=0;
		}
	      break;
	    }
	  case StreamTokenizer.TT_EOF:
	    {
	      reading=false;
	      column--;
	      st = null;
	      break;
	    }
	  case StreamTokenizer.TT_NUMBER:
	    {
	      valeur = (int)st.nval;
	      if (patgrid)
 		{ pattab[column][line]=valeur;
		if (valeur >= 2) nb_gums_left++;
		}
	      else tab[column][line]=valeur;
	      
	      column++;
	      break;
	    }
	  default :
	    break;
	  }
      }
    
    // on avertit l'afficheur afin qu'il construise l'image
    // correspondant au labyrinthe charge
    
    setChanged();
    notifyObservers(new Position(-1,-1));

  }

  /** renvoie la valeur de la case 'position' de la grille des patgums
   */
  public int eatPatGum(Position position) {
    Position index;
    int val;
    if (isOnSquare(position))
      {
	
	index = getSquare(position);
	val= patgrid[index.x][index.y];
	if (val !=0) 
	  {
	    
	    nb_gums_left--;
	    patgrid[index.x][index.y]=0;
	
	    // on avertit l'afficheur de mettre a jour la grille
	    setChanged();
	    notifyObservers(index);
	    
	    
	    
	  }
	return val;
      }
    else 
      return 0;
  }
  
  
  public String toString() {
    return new String("pacgrid");
  }
  
  // renvoie la valeur de la grille a la position (x,y)
  public int getGridValue(int x,int y)
  {
    return grid[x][y];  
  }
  
  // renvoie la position de la maison des fantomes
  
  public boolean isHome(int x,int y) {
    return ((x == 200) && ((y >= 125) && (y <= 160)));
  }
  
  // cette methode renvoie une position deduite
  // de la position pos de l'acteur et de la direction de 
  // son mouvement
  // on peut ainsi gerer les passages secrets 
  // Amelioration : on code les passages secrets directements dans la grille
  
  public Position computePosition(Position pos,Position dir) {

    Position pos2= new Position(pos.x+dir.x,pos.y+dir.y);
    if (pos2.x < 5) pos2.setX(390);
    else { if ((pos2.x +20) >= 420) pos2.setX(10);}
    if (pos2.y < 5) pos2.setY(310);
    else { if (pos2.y > 310) pos2.setY(0);}
    if ((isHome(pos2.x,pos2.y)) && (dir == Position.N)) 
      pos2.setY(120);
    return pos2;
  }

  public Position getPacPosition() {
    return new Position(200,200);
  }
  
  public Position getGhostPosition() {
    return new Position(200,160);
  }

  // renvoie true si la case est une route
  private boolean isRoad(int x,int y) {
    return (grid[x][y] == 0);
  }

  // retourne true si la position(x,y) est une position
  // valide pour l'acteur appelant cette methode
  
  public boolean isValidPosition(int x,int y) {
   
    if ((x < 0) || ( x > ((nb_colonnes-1) * square_size))
	|| (y < 0) || (y >= ((nb_lignes-1) * square_size)))
      return false;
    else 
      {
    if ((isRoad(x / square_size,y / square_size)) &&
	(isRoad((x+15) / square_size,y / square_size)) &&
	(isRoad((x + 15) /square_size,(y + 15)/square_size)) &&
	(isRoad(x / square_size,(y + 15) / square_size)))
      return true;
    else return false;
      }
  }
  
 
  public int getPatValue(int x,int y)
  {
    return patgrid[x][y];
  }
  public int getSquareSize() 
  {
    return square_size; 
  }
  public int getNbColumns() {
    return nb_colonnes;
  }
  public int getNbLines() {
    return nb_lignes;
  }

  // renvoie la valeur de la case associee a la position passe
  // en parametre
  
  public Position getSquare(Position pos) {
    return new Position((pos.x / square_size),(pos.y / square_size));
  }

 
  public boolean isPatGum(int val) {
    return (val > 1);
  }
  
  public boolean isSuperPatGum(int val) {
    return (val == 3);
  }
  
  // renvoie true si la position passee en parametre
  // est sur une case

  public boolean isOnSquare(Position pos) {
    
    int vligne = (pos.y % square_size);
    int vcolonne =  (pos.x % square_size);
    
    if ((vligne <= 5) && (vcolonne <= 5))
      return true;
    else return false;
  }
  
  public boolean isEmpty() {
    return (nb_gums_left == 0);
  }


}








