import java.util.*;
import java.awt.event.*;

/**  Classe principale
 *   La classe PacGame effectue l'interaction entre l'interface graphique
 *   et le jeu
 */
public class PacGame extends KeyAdapter implements Observer ,ActionListener,WindowListener, ItemListener,KeyListener {
  
  public Game game;
  boolean paused=false;
  PacInterface pacInterface;
  NameDialog nd;
  
  public PacGame() {
    // on instancie l'interface
    // on instancie le jeu

    game = new Game();

    pacInterface= new PacInterface(this,game);


    Afficheur aff = pacInterface.getAfficheur();
    
    // on ajoute les observer

    game.pacgrid.addObserver(aff);
    game.score.addObserver(this);
  }
  
  public static void main (String args[]) {

    new PacGame();
    
    
  }
  public void update(Observable o,Object arg) {
    new NameDialog(pacInterface.frame,(Score)o);
  }

  // l'ecouteur de touche
  public void keyPressed(KeyEvent e) {
    
    switch (e.getKeyCode())
      {
      case KeyEvent.VK_UP : game.user.setWantedDirection(Position.N);break;
      case KeyEvent.VK_DOWN : game.user.setWantedDirection(Position.S);break;
      case KeyEvent.VK_LEFT : game.user.setWantedDirection(Position.W);break;
      case KeyEvent.VK_RIGHT :game.user.setWantedDirection(Position.E);break;
      default : {}
      } 
  }
  
  // l'ecouteur de fenetre
  public void windowOpened(WindowEvent e){}

    /**
     * Invoked when a window is in the process of being closed.
     * The close operation can be overridden at this point.
     */
  public void windowClosing(WindowEvent e) {
    game.quit();
  }

    /**
     * Invoked when a window has been closed.
     */
  public void windowClosed(WindowEvent e){}

    /**
     * Invoked when a window is iconified.
     */
  
  public void windowIconified(WindowEvent e) {
    game.stop();
    pacInterface.getProjecteur().suspend();
    pacInterface.getProjecteur().requestFocus();
  }

    /**
     * Invoked when a window is de-iconified.
     */
  public void windowDeiconified(WindowEvent e){

    pacInterface.getProjecteur().resume();
    game.resume();
    pacInterface.getProjecteur().requestFocus();
    

  }

    /**
     * Invoked when a window is activated.
     */
  public void windowActivated(WindowEvent e){}

    /**
     * Invoked when a window is de-activated.
     */
  public void windowDeactivated(WindowEvent e){}


  
  public void itemStateChanged(ItemEvent e) {
    String item=e.getItem().toString();
    if (item.equals("Easy"))
      {
	game.setDifficulty(3);
	game.demo=false;
      }
    
    else
      if (item.equals("Normal"))
	{game.setDifficulty(2);
    	game.demo=false;
	}
      else
	if (item.equals("Hard"))
	 { 
	  game.setDifficulty(1);
	game.demo=false;
	}
    else
	if (item.equals("Demo"))
	game.demo=true;
	else 
	  {
	    int nbghost= new Integer(e.getItem().toString()).intValue();
	    game.setNbGhosts(nbghost);
	  }
    
    pacInterface.getProjecteur().requestFocus();
  }
  
  
  
  // l'ecouteur d'action
  
  public void actionPerformed(ActionEvent ae) {
      
    String command = ae.getActionCommand();
      
      
    if (command.equals("Start"))
      { 
	game.clean();
	game.startGame();
      }
      else {
	
	if (command.equals("Pause")) {
	  
	  if (!paused) 
	    {pacInterface.getProjecteur().suspend();game.stop();paused=true;} 
	  else 
	    {pacInterface.getProjecteur().resume();game.resume();paused=false;}
	}
	else {
	  if (command.equals("Quit"))
	    game.quit(); 
	 
	}
      }
    
    pacInterface.getProjecteur().requestFocus();
  
  }
}

  


