import java.util.*;
import java.awt.*;


public class Game   {

  // la pacgrid ou evoluent les personnages
  PacGrid pacgrid;

  // le pacman
  Pacman pacman;

  // le nombre max de fantomes
  int max_fantome=8;
  
  //le nombre de fantomes initial
  int nb_fantomes=4;

  // les fantomes
  Fantome[] ghosts = new Fantome[max_fantome];

  // le nombre de fantomes courants
  int nbGhost=0;

  // le vecteur de tous les acteurs evoluant
  Vector acteurs;
  
  // le score
  Score score;

  //demo
  boolean demo=false;

  // le niveau de difficulte
  int difficulty=2;
  
  // le nombre de vies
  int nb_lifes;
  
  // le nom du joueur
  String name="Player";
  
  // indique si le jeu est en pause
  public boolean message=true;

  // indentificateur du message
  public int msgID=5;

  //La strategie du pacman 
  User user;
  
  public Game() {
   
   
    score = new Score();

    nb_lifes = 3;
    
    pacgrid = new PacGrid();
  
    user=new User(pacgrid);

    startState();
        
    
  }
   
 

  
  //positionne le nombre de fantomes initial
  public void setNbGhosts(int i){
      nb_fantomes=i;
  }

  //positionne le niveau de difficulte du jeu
  public void setDifficulty(int i) {
    difficulty = i;
  }

  //positionne la vitesse des differents acteurs
  static  void setSpeed(int val) {
   
    Fantome.setVitesse(val);
    Pacman.setVitesse(val);
   
  }
  // Positionnement des differents etats du jeu

  private  void startState() {
    message=true;
    msgID=1;
  }

  
  private void gameOverState() {
    message=true;
    msgID=3;
  }
  
  private void hiScoreState() {
    message=true;
    msgID=4;
   
  }

  
  private void levelState() {
    message=true;
    msgID=2;
  }

  private void looseLifeState() {
    message=true;
    msgID=0;
  }

 
  private void removeState() {
    message=false;
  }


  //suspend tous les acteurs
  public  void stop() {
    if (Acteur.tg != null)
      Acteur.suspendAll();
  }
 
  //reprend l'execution des differents acteurs
  public void resume() {
   if (Acteur.tg != null)
    Acteur.resumeAll();
  }


  // methode utilisee pour passer au niveau suivant
  private void goNextLevel() {
   
    levelState();
    try {Thread.sleep(1000);} catch (Exception e) {}
    pacgrid.nextLevel();

    if (Fantome.scared_time > 40) Fantome.scared_time-=20;
    
    
    Enumeration l = acteurs.elements();
    while (l.hasMoreElements())
       ((Acteur)l.nextElement()).resume();
   
    removeState();

  }
  
  // methode utilisee pour passer a la vie  suivante
   private void goNextLife() {


    looseLifeState();
    try {Thread.sleep(1000);} catch (Exception e) {}
        Enumeration l = acteurs.elements();
	      while (l.hasMoreElements())
		((Acteur)l.nextElement()).resume();
    
    removeState();
    
   }
  
  // ajoute un fantome 
  private void addGhost(boolean start) {

    if (!(nbGhost >= max_fantome))
      {
       ghosts[nbGhost]=new Fantome(nbGhost%4);
       acteurs.addElement(ghosts[nbGhost]);
       
       // un fantome sur 4 utilise la strategie Smart
       // les autres utilisent la strategie Basic
       
       Strategie strat;  
	switch(ghosts[nbGhost].getID()) {
	case 0: strat= new Smart(pacgrid,pacman);break;
	default : strat=new Basic(pacgrid);break;
	};

	ghosts[nbGhost].setStrategie(strat);
	
	
	if (start) ghosts[nbGhost].start();
	nbGhost++;

      }
  }


  // debut du jeu
  public void startGame() {
    
    
    pacgrid.nextLevel();

    Acteur.tg=new ThreadGroup("Actors");
    
    score.reset();

    nb_lifes=3;

    acteurs=new Vector();
  
    pacman = new Pacman();

    acteurs.addElement(pacman);

    for (int i=0; i< nb_fantomes ; i++) {
      addGhost(false);
    }

    Fantome.scared_time=(difficulty * 50);

    Fantome.setVitesse(difficulty * 30);

    Pacman.setVitesse(60);
    
    new Regle();
    
    if (!demo)        
      pacman.setStrategie(user); 
    else 
      pacman.setStrategie(new Basic(pacgrid));   
    removeState();
    
    pacman.start();

    for (int i= 0 ; i < nbGhost ; i++)
    {  
      ghosts[i].start();
    }

  }
  
  
   
  // fin du jeu
  public void endGame() {
    
    // on rentre dans les hi-score?
    gameOverState();


    if (!demo)
      score.enterHiScores();
   
   

   // on tue les acteurs

   Enumeration liste=acteurs.elements();

    while (liste.hasMoreElements()) 
      {
  	
  	((Acteur)liste.nextElement()).terminate();
  
     }
    
    
     try {Thread.sleep(1000);} catch (Exception e) {}

    
     pacgrid.resetLevel();
    
	
     hiScoreState();
     
     acteurs=null;
     
     nbGhost=0;
  }


  // methode utilisee l'arret d'une partie en cours
  
  public void clean() {

    if (acteurs != null) {
    Enumeration liste=acteurs.elements();

    pacgrid.resetLevel();
  
    while (liste.hasMoreElements()) 
      {
	
	((Acteur)liste.nextElement()).terminate();
      }
    }
    
    nbGhost=0;
    
    acteurs=null;
    
  }

  // fin de l'application

  public void quit() {
    score.writeHiScores();
    System.exit(0);
  }

  
 
  
  //classe interne gerant les interactions entre les acteurs
  
public class Regle implements Observer {

  public Regle() {

    //La class observe tous les acteurs
    
    Enumeration liste=acteurs.elements();
    
    while (liste.hasMoreElements()) 
      {
	
	((Acteur)liste.nextElement()).addObserver(this);
      }
    
  }

  

  
  public void update (Observable o,Object arg) {
    String acteurID=((Acteur)o).getName();
    
    if (acteurID.equals("Pacman"))
      interaction((Pacman)o);
      else 
      {
      if (acteurID.equals("Ghost"))
	interaction((Fantome)o);
      else 
	interaction((Acteur)o);
      }
    
  }

  private void interaction(Acteur acteur) {
  }



  //Gere les interactions du fantome
  private void interaction(Fantome ghost) {

    
    if ((ghost.getPosition()).isEqual(pacman.getPosition(),(pacgrid.square_size / 2)))
      {
	
	if (ghost.isEatable())
	  {

	    score.incremente(300);
	    ghost.kill();
	  }

	else 
	  {
	    if (pacman.isEatable()) {
	      
	      pacman.setEatable(false);

	      pacman.kill();
	      
	      Enumeration l = acteurs.elements();
	      
	      while (l.hasMoreElements())
		((Acteur)l.nextElement()).suspend(); 
		   
	      nb_lifes--;
	      

	      if (nb_lifes == 0)
		{ 
		  endGame();
		
		}
	      
	       else 
		 {
		   goNextLife();
		   for (int i=0 ;i<nbGhost; i++)
		     ghosts[i].setScared(false);
		   Enumeration liste1 = acteurs.elements();
		   while (liste1.hasMoreElements())
		     ((Acteur)liste1.nextElement()).setStartPosition(); 
		   
		   pacman.setEatable(true);
		   
		 }
	    }
	  }
      }
  }

  // Gere les interactions du pacman
  
   private void interaction(Pacman pac) {

    int val;
    
    val = pacgrid.eatPatGum(pacman.getPosition());
    
    if (pacgrid.isPatGum(val)) 
      {
	
	score.incremente(10);
	
	if (pacgrid.isSuperPatGum(val)){
	  score.incremente(40);
	  
	  for (int i=0;i<nbGhost;i++)
	    ghosts[i].setScared(true);
	}
	
	if (pacgrid.isEmpty()) 
	  {
	    Enumeration l2 = acteurs.elements();
	     while (l2.hasMoreElements())
		((Acteur)l2.nextElement()).suspend(); 
	 
	     
	     for (int i=0 ;i<nbGhost; i++)
	       ghosts[i].setScared(false);
	     
	     goNextLevel();
	    
	    Enumeration liste3 = acteurs.elements();
	    while(liste3.hasMoreElements()) {
	      ((Acteur)liste3.nextElement()).setStartPosition();

	      
	    }
	    
	  }
      }
   }
}
}

  


