/** Fantome class. Definit les caracteristiques d'un fantome
 * le fantome se deplace dans la grille a intervalle de temps
 * reguliers
 */

public class Fantome extends Acteur implements Runnable 
{
  
  private boolean scared;

  private boolean alive;
  
  
  private volatile Thread t;
  boolean threadSuspended = true;
  
  // entier representant l'etat du fantome
  int state;
  
  
  // strategie attachee au fantome
  Strategie strategie;
  
  // temps durant lequel le fantome rest effraye
  static int scared_time;

  int scared_counter;
  
  // vitesse de deplacement du fantome
  static int vitesse=60;

  /** Le constructeur positionne le look(couleur) et la valeur du fantome
   */
  public Fantome(int look)
  {
    super(new Position(180+((look%3)*20),160),false,look);
    
    scared=false;
      
    state=0;
    
    alive=true;
    
    
    
    }


 /** Positionne la strategie du fantome
  * lui permettant de deduire sa nouvelle poosition
  */ 

  public void setStrategie(Strategie strategie) {
    this.strategie=strategie;
  }
  
  /** Positionne la vitesse de deplacemant du fantome
   */
  public static void setVitesse(int vit) {

    if ((vit >= 20) && (vit <= 300))
      vitesse=vit;
    
  }


 
  // suspend le thread
  public void suspend() {
    threadSuspended = true;
  }
 

  // lance l'execution du thread
  public synchronized void start()
  {
    
    t=new Thread(Acteur.tg ,this);
    threadSuspended = false;
    t.start();
  }
  // termine l'execution du thread
  public void terminate() {
    t=null;
  }

  // repositionne les attributs du fantome
  
  public void resetPosition() {

    setStartPosition();
    setEatable(false);

  }
  // reprend l'execution du thread  
  public void resume() {
    threadSuspended=false;
  }

    
 
  public boolean isScared()
  {
      return scared;
      
  }
  public String getName() {
    return "Ghost";
  }
  
  // renvoie un entier representant l'etat actuel du fantome
  public int getIndex() {
    if (isEatable())
      return 2;
    else
    {
      if (Math.random() > 0.7)
	return 0;
      else
	return 1;
    }
  }

  // Met le fantome dans un etat effraye ou restitue son etat normal
  public void setScared(boolean scare) {
    scared=scare;
    setEatable(scare);
    scared_counter=scared_time;
  }

  // operations a effectuer lorsque le fantome est mange
  public void kill() {
    setStartPosition();
    scared=false;
    setEatable(false);
  }

 
  // La tache de fond executee par le fantome
  public void run() {
    Thread thisThread = Thread.currentThread();
    while (t == thisThread) {
      
      try {
      
      if (threadSuspended)
	synchronized(this) {
	      while (threadSuspended && t==thisThread)
		{t.sleep(40);
		}
      }
      else
	{
	  
	  // on demande a la strategie de nous donner une nouvelle
	  // position
	  position=strategie.move(getPosition());

	  // si effraye on decremente le compteur
	  if (scared) {
	    if (scared_counter > 0) 
	      {
		scared_counter--;
	      }	else  
		{
		  scared_counter=scared_time;
		  scared=false;
		  setEatable(false);
		}
	  }
	  
	  setChanged();
	  notifyObservers();
	  
	  
	  thisThread.sleep(vitesse);
	  
	  
	  
	}
	  }
    
    catch (InterruptedException e){
    }
  }

}
}



